/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.SleepingDatabaseJob;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.SessionGarbageCollection;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.issues.common.BatchIssueSource;
import org.simantics.issues.common.BatchIssueValidationContext;
import org.simantics.issues.common.ManagedIssues;
import org.simantics.issues.common.SelectedModelBatchIssueSources;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.issues.preferences.IssuePreferenceUtil;
import org.simantics.issues.ui.handler.Messages;
import org.simantics.modeling.utils.BatchValidations;
import org.simantics.utils.ui.ExceptionUtils;

public class RunActiveValidations
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Runnable postValidation = null;
        this.run(postValidation);
        return null;
    }

    public void run(Runnable postValidation) {
        final Session session = Simantics.getSession();
        final ArrayList<BatchIssueSource> validations = new ArrayList<BatchIssueSource>();
        final BatchIssueValidationContext context = new BatchIssueValidationContext();
        try {
            SleepingDatabaseJob dbLock = new SleepingDatabaseJob(Messages.RunActiveValidations_ValidationPreparation).scheduleAndWaitForRunning();
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            Resource model = (Resource)session.sync((ReadInterface)new PossibleActiveModel(Simantics.getProjectResource()));
                            if (model == null) {
                                return;
                            }
                            try {
                                RunActiveValidations.toBatchIssueSources((RequestProcessor)session, (Collection)session.syncRequest((Read)new SelectedModelBatchIssueSources(model)), validations);
                                SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RunActiveValidations_MonitorPreparingResourcesForValidation, (int)100);
                                context.contexts = Collections.singletonList(model);
                                context.domain = ModelTransferableGraphSourceRequest.getDomainOnly((RequestProcessor)session, (IProgressMonitor)monitor, (Resource)model);
                                if (monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                            }
                            catch (DatabaseException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            finally {
                dbLock.disposeAndJoin();
            }
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof OperationCanceledException) {
                return;
            }
            ExceptionUtils.logAndShowError((Throwable)e.getTargetException());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (!validations.isEmpty() && !context.contexts.isEmpty()) {
            RunActiveValidations.run(postValidation, validations, context);
        }
    }

    static Collection<BatchIssueSource> toBatchIssueSources(RequestProcessor processor, Collection<Resource> sources, Collection<BatchIssueSource> result) throws DatabaseException {
        for (Resource source : sources) {
            BatchIssueSource bis = (BatchIssueSource)processor.syncRequest(Queries.adapt((Resource)source, BatchIssueSource.class, (boolean)true));
            if (bis == null) continue;
            result.add(bis);
        }
        return result;
    }

    public static void run(Runnable postValidation, final Collection<BatchIssueSource> validations, final BatchIssueValidationContext context) {
        SleepingDatabaseJob dbLock = new SleepingDatabaseJob(Messages.RunActiveValidations_Validation);
        try {
            dbLock.scheduleAndWaitForRunning();
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RunActiveValidations_ValidateModel, (int)100);
                                int maxWrittenIssues = IssuePreferenceUtil.getPreferences().maxBatchIssuesToWrite;
                                int writtenIssues = 0;
                                for (BatchIssueSource source : validations) {
                                    Map results = BatchValidations.validate((IProgressMonitor)progress.newChild(90, 0), (BatchIssueSource)source, (BatchIssueValidationContext)context);
                                    if (progress.isCanceled()) {
                                        throw new OperationCanceledException();
                                    }
                                    Collection removed = (Collection)Simantics.getSession().syncRequest((Read)new ResourceRead<Collection<Resource>>(source.getResource()){

                                        public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
                                            IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                                            ArrayList<Resource> result = new ArrayList<Resource>();
                                            for (Resource issue : (Collection)graph.syncRequest((Read)new ManagedIssues(this.resource))) {
                                                Resource mainContext;
                                                Resource list = graph.getSingleObject(issue, ISSUE.Issue_HasContexts);
                                                List l = ListUtils.toList((ReadGraph)graph, (Resource)list);
                                                if (l.size() <= 0 || graph.hasStatement(mainContext = (Resource)l.get(0))) continue;
                                                result.add(mainContext);
                                            }
                                            return result;
                                        }
                                    });
                                    for (Resource r : removed) {
                                        results.put(r, Collections.emptySet());
                                    }
                                    if (progress.isCanceled()) {
                                        throw new OperationCanceledException();
                                    }
                                    int wroteIssues = BatchValidations.store((IProgressMonitor)progress.newChild(10, 0), (Resource)source.getResource(), (Map)results, (int)Math.max(0, maxWrittenIssues - writtenIssues));
                                    writtenIssues += wroteIssues;
                                    SessionGarbageCollection.gc(null, (Session)Simantics.getSession(), (boolean)true, null);
                                }
                            }
                            catch (OperationCanceledException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            finally {
                dbLock.disposeAndJoin();
            }
            if (postValidation != null) {
                postValidation.run();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.logAndShowError((Throwable)e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }
}

