/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.OrderedSet;
import org.simantics.db.common.procedure.wrapper.SetListenerToSingleSetListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.SetListener;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.profile.Group;

public class TypeGroup
implements Group {
    private final Collection<Resource> types;
    private final String name;

    public TypeGroup(String name, Resource type) {
        this(name, new Resource[]{type});
    }

    public TypeGroup(String name, Resource ... types) {
        this.types = Arrays.asList(types);
        this.name = name;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.types.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeGroup other = (TypeGroup)obj;
        return this.types.equals(other.types);
    }

    public TypeGroup(ReadGraph graph, Resource group) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.name = (String)graph.getPossibleRelatedValue(group, L0.HasName, (Binding)Bindings.STRING);
        this.types = graph.getObjects(group, DIA.TypeGroup_HasType);
    }

    public void trackItems(RequestProcessor processor, final Resource runtimeDiagram, SetListener<Resource> listener) throws DatabaseException {
        if (this.types.isEmpty()) {
            System.out.println("TypeGroup has no types!");
            return;
        }
        processor.syncRequest((Read)new BinaryRead<Resource, Collection<Resource>, Collection<Resource>>(runtimeDiagram, this.types){

            public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
                HashSet<Resource> result = new HashSet<Resource>();
                Resource realDiagram = graph.getPossibleObject(runtimeDiagram, DiagramResource.getInstance((ReadGraph)graph).RuntimeDiagram_HasConfiguration);
                if (realDiagram == null) {
                    return result;
                }
                Collection elements = graph.syncRequest((AsyncMultiRead)new OrderedSet(realDiagram));
                for (Resource element : elements) {
                    Set elementTypes = graph.getTypes(element);
                    if (Collections.disjoint(TypeGroup.this.types, elementTypes)) continue;
                    result.add(element);
                }
                return result;
            }
        }, (Listener)new SetListenerToSingleSetListener(listener));
    }

    public String toString() {
        return "every '" + this.name + "'";
    }
}

