/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTaskMirror;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.util.FileUtils;

public class SummaryJUnitResultFormatter
implements JUnitResultFormatter,
JUnitTaskMirror.SummaryJUnitResultFormatterMirror {
    private static final double ONE_SECOND = 1000.0;
    private NumberFormat nf = NumberFormat.getInstance();
    private OutputStream out;
    private boolean withOutAndErr = false;
    private String systemOutput = null;
    private String systemError = null;

    private synchronized void writeOutputLine(byte[] b) {
        try {
            this.out.write(b);
            this.out.flush();
        }
        catch (IOException ioex) {
            throw new BuildException("Unable to write summary output", (Throwable)ioex);
        }
    }

    @Override
    public void startTestSuite(JUnitTest suite) {
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("Running ");
        int antThreadID = suite.getThread();
        sb.append(suite.getName());
        if (antThreadID > 0) {
            sb.append(" in thread ");
            sb.append(antThreadID);
        }
        sb.append(newLine);
        this.writeOutputLine(sb.toString().getBytes());
    }

    public void startTest(Test t) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable t) {
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
    }

    @Override
    public void setOutput(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setSystemOutput(String out) {
        this.systemOutput = out;
    }

    @Override
    public void setSystemError(String err) {
        this.systemError = err;
    }

    @Override
    public void setWithOutAndErr(boolean value) {
        this.withOutAndErr = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endTestSuite(JUnitTest suite) throws BuildException {
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("Tests run: ");
        sb.append(suite.runCount());
        sb.append(", Failures: ");
        sb.append(suite.failureCount());
        sb.append(", Errors: ");
        sb.append(suite.errorCount());
        sb.append(", Skipped: ");
        sb.append(suite.skipCount());
        sb.append(", Time elapsed: ");
        sb.append(this.nf.format((double)suite.getRunTime() / 1000.0));
        sb.append(" sec");
        if (suite.getThread() > 0) {
            sb.append(", Thread: ");
            sb.append(suite.getThread());
            sb.append(", Class: ");
            sb.append(suite.getName());
        }
        sb.append(newLine);
        if (this.withOutAndErr) {
            if (this.systemOutput != null && this.systemOutput.length() > 0) {
                sb.append("Output:").append(newLine).append(this.systemOutput).append(newLine);
            }
            if (this.systemError != null && this.systemError.length() > 0) {
                sb.append("Error: ").append(newLine).append(this.systemError).append(newLine);
            }
        }
        try {
            this.writeOutputLine(sb.toString().getBytes());
        }
        finally {
            if (this.out != System.out && this.out != System.err) {
                FileUtils.close((OutputStream)this.out);
            }
        }
    }
}

