/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.splashHandlers;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.splash.AbstractSplashHandler;
import org.simantics.workbench.internal.Activator;

public class InteractiveSplashHandler
extends AbstractSplashHandler {
    private static final String SPLASH_IMAGE = "simantics.png";
    private static final int FADE_TIME_MS = 250;
    private static final int F_LABEL_HORIZONTAL_INDENT = 10;
    private static final int F_BUTTON_WIDTH_HINT = 80;
    private static final int F_TEXT_WIDTH_HINT = 175;
    private static final int F_COLUMN_COUNT = 3;
    private Composite fCompositeLogin = null;
    private Text fTextUsername = null;
    private Text fTextPassword = null;
    private Button fButtonOK = null;
    private Button fButtonCancel = null;
    private boolean fAuthenticated = false;
    private Image splashImage;
    private Image currentBackground;
    private long fadeStartTime = 0L;
    private boolean fadeComplete = false;
    private Timer watchdogTimer = new Timer("splash-watchdog");
    private State state = State.INIT;

    private void updateBackground1(Shell splash) {
        Point size = splash.getSize();
        Point pt = splash.getLocation();
        splash.setRegion(new Region());
        Rectangle clientArea = splash.getDisplay().getClientArea();
        Image backgroundImage = new Image((Device)splash.getDisplay(), clientArea.width, clientArea.height);
        GC gc = new GC((Drawable)splash.getDisplay());
        gc.copyArea(backgroundImage, 0, 0);
        gc.dispose();
        Image newSplashBackground = new Image((Device)splash.getDisplay(), size.x, size.y);
        GC gc2 = new GC((Drawable)newSplashBackground);
        gc2.drawImage(backgroundImage, pt.x, pt.y, size.x, size.y, 0, 0, size.x, size.y);
        gc2.drawImage(this.splashImage, 0, 0);
        gc2.dispose();
        backgroundImage.dispose();
        Region r = new Region();
        Rectangle r2 = this.splashImage.getBounds();
        r.add(r2);
        splash.setRegion(r);
        Image old = splash.getBackgroundImage();
        splash.setBackgroundImage(newSplashBackground);
        this.currentBackground = newSplashBackground;
        if (old != null) {
            old.dispose();
        }
    }

    private void updateBackground2(Shell splash) {
        Point size = splash.getSize();
        Point pt = splash.getLocation();
        splash.setRegion(new Region());
        Rectangle clientArea = splash.getDisplay().getClientArea();
        Image backgroundImage = new Image((Device)splash.getDisplay(), clientArea.width, clientArea.height);
        GC gc = new GC((Drawable)splash.getDisplay());
        gc.copyArea(backgroundImage, 0, 0);
        gc.dispose();
        Image newSplashBackground = new Image((Device)splash.getDisplay(), size.x, size.y);
        GC gc2 = new GC((Drawable)newSplashBackground);
        gc2.drawImage(backgroundImage, pt.x, pt.y, size.x, size.y, 0, 0, size.x, size.y);
        gc2.dispose();
        backgroundImage.dispose();
        Region r = new Region();
        Rectangle r2 = newSplashBackground.getBounds();
        r.add(r2);
        splash.setRegion(r);
        Image old = splash.getBackgroundImage();
        splash.setBackgroundImage(newSplashBackground);
        this.currentBackground = newSplashBackground;
        if (old != null) {
            old.dispose();
        }
    }

    private void initializeBackground(Shell splash) {
        Point size = splash.getSize();
        splash.getLocation();
        Image newSplashBackground = new Image((Device)splash.getDisplay(), size.x, size.y);
        ImageData imgData = newSplashBackground.getImageData();
        imgData.alpha = 0;
        Region r = new Region();
        Rectangle r2 = this.splashImage.getBounds();
        Rectangle r3 = new Rectangle(r2.x, r2.y, r2.width, r2.height);
        r.add(r3);
        splash.setRegion(r);
        splash.setBackgroundImage(newSplashBackground);
        this.currentBackground = newSplashBackground;
    }

    public void dispose() {
        super.dispose();
        if (this.splashImage != null) {
            this.splashImage.dispose();
        }
        if (this.currentBackground != null) {
            this.currentBackground.dispose();
        }
    }

    public void init(Shell splash) {
        super.init(splash);
        ImageDescriptor splashDesc = Activator.getImageDescriptor(SPLASH_IMAGE);
        if (splashDesc == null) {
            return;
        }
        this.splashImage = splashDesc.createImage();
        splash.setSize(this.splashImage.getBounds().width, this.splashImage.getBounds().height);
        Point pt = splash.getLocation();
        pt.x -= this.splashImage.getBounds().width / 2;
        pt.y -= this.splashImage.getBounds().height / 2;
        splash.setLocation(pt);
        this.updateBackground2(splash);
        this.state = this.state.ok();
        this.configureUISplash();
        this.createUI();
        this.createUIListeners();
        splash.layout(true);
        this.doEventLoop();
    }

    private void doEventLoop() {
        Shell splash = this.getSplash();
        this.watchdogTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                InteractiveSplashHandler.this.watchdogTimer.cancel();
                InteractiveSplashHandler.this.fadeComplete = true;
            }
        }, 300L);
        while (!this.fadeComplete) {
            if (splash.getDisplay().readAndDispatch()) continue;
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        splash.redraw();
        while (splash.getDisplay().readAndDispatch()) {
        }
    }

    private void createUIListeners() {
        this.fCompositeLogin.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                float timeElapsed = 0.0f;
                if (InteractiveSplashHandler.this.fadeStartTime == 0L) {
                    InteractiveSplashHandler.this.fadeStartTime = System.currentTimeMillis();
                } else {
                    timeElapsed = System.currentTimeMillis() - InteractiveSplashHandler.this.fadeStartTime;
                }
                int fade = Math.min(255, Math.round(255.0f * timeElapsed / 250.0f));
                if (fade >= 255) {
                    InteractiveSplashHandler.this.fadeComplete = true;
                }
                GC gc = event.gc;
                gc.drawImage(InteractiveSplashHandler.this.currentBackground, 0, 0);
                gc.setAlpha(fade);
                gc.drawImage(InteractiveSplashHandler.this.splashImage, 0, 0);
                if (!InteractiveSplashHandler.this.fadeComplete) {
                    InteractiveSplashHandler.this.getSplash().getDisplay().timerExec(25, new Runnable(){

                        @Override
                        public void run() {
                            Shell s = InteractiveSplashHandler.this.getSplash();
                            if (s != null && !s.isDisposed()) {
                                Point size = s.getSize();
                                s.redraw(0, 0, size.x, size.y, true);
                            }
                        }
                    });
                }
            }
        });
    }

    private void createUIListenersButtonCancel() {
        this.fButtonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InteractiveSplashHandler.this.handleButtonCancelWidgetSelected();
            }
        });
    }

    private void handleButtonCancelWidgetSelected() {
        this.getSplash().getDisplay().close();
        System.exit(0);
    }

    private void createUIListenersButtonOK() {
        this.fButtonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InteractiveSplashHandler.this.handleButtonOKWidgetSelected();
            }
        });
    }

    private void handleButtonOKWidgetSelected() {
        String username = this.fTextUsername.getText();
        String password = this.fTextPassword.getText();
        if (username.length() > 0 && password.length() > 0) {
            this.fAuthenticated = true;
        } else {
            MessageDialog.openError((Shell)this.getSplash(), (String)"Authentication Failed", (String)"A username and password must be specified to login.");
        }
    }

    private void createUI() {
        this.createUICompositeLogin();
    }

    private void createUIButtonCancel() {
        this.fButtonCancel = new Button(this.fCompositeLogin, 8);
        this.fButtonCancel.setText("Cancel");
        GridData data = new GridData(0, 0, false, false);
        data.widthHint = 80;
        data.verticalIndent = 10;
        this.fButtonCancel.setLayoutData((Object)data);
    }

    private void createUIButtonOK() {
        this.fButtonOK = new Button(this.fCompositeLogin, 8);
        this.fButtonOK.setText("OK");
        GridData data = new GridData(0, 0, false, false);
        data.widthHint = 80;
        data.verticalIndent = 10;
        this.fButtonOK.setLayoutData((Object)data);
    }

    private void createUILabelBlank() {
        Label label = new Label(this.fCompositeLogin, 0);
        label.setVisible(false);
    }

    private void createUITextPassword() {
        int style = 0x400800;
        this.fTextPassword = new Text(this.fCompositeLogin, style);
        GridData data = new GridData(0, 0, false, false);
        data.widthHint = 175;
        data.horizontalSpan = 2;
        this.fTextPassword.setLayoutData((Object)data);
    }

    private void createUILabelPassword() {
        Label label = new Label(this.fCompositeLogin, 0);
        label.setText("&Password:");
        GridData data = new GridData();
        data.horizontalIndent = 10;
        label.setLayoutData((Object)data);
    }

    private void createUITextUserName() {
        this.fTextUsername = new Text(this.fCompositeLogin, 2048);
        GridData data = new GridData(0, 0, false, false);
        data.widthHint = 175;
        data.horizontalSpan = 2;
        this.fTextUsername.setLayoutData((Object)data);
    }

    private void createUILabelUserName() {
        Label label = new Label(this.fCompositeLogin, 0);
        label.setText("&User Name:");
        GridData data = new GridData();
        data.horizontalIndent = 10;
        label.setLayoutData((Object)data);
    }

    private void createUICompositeBlank() {
        Composite spanner = new Composite(this.fCompositeLogin, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = 3;
        spanner.setLayoutData((Object)data);
    }

    private void createUICompositeLogin() {
        this.fCompositeLogin = new Canvas((Composite)this.getSplash(), 0x20000000);
        GridLayout layout = new GridLayout(3, false);
        this.fCompositeLogin.setLayout((Layout)layout);
    }

    private void configureUISplash() {
        FillLayout layout = new FillLayout();
        this.getSplash().setLayout((Layout)layout);
        this.getSplash().setBackgroundMode(1);
    }

    static enum State {
        INIT,
        OK,
        DIRTY,
        UPDATED;


        State ok() {
            return OK;
        }

        State dirty() {
            return DIRTY;
        }

        State updated() {
            return UPDATED;
        }
    }
}

