/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor2;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.simantics.scl.ui.editor2.SingleTokenScanner;
import org.simantics.scl.ui.editor2.StringTokenScanner;
import org.simantics.scl.ui.info.SCLInfo;

public class SCLPresentationReconciler
extends PresentationReconciler {
    private static final FontDescriptor FONT_NORMAL = FontDescriptor.createFrom((String)"Consolas", (int)10, (int)0);
    private static final FontDescriptor FONT_BOLD = FontDescriptor.createFrom((String)"Consolas", (int)10, (int)1);

    public SCLPresentationReconciler(ResourceManager resourceManager) {
        Font font = resourceManager.createFont(FONT_NORMAL);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(resourceManager.createColor(new RGB(63, 127, 95)), null, 0, font)));
        this.setDamager((IPresentationDamager)dr, "COMMENT");
        this.setRepairer((IPresentationRepairer)dr, "COMMENT");
        dr = new DefaultDamagerRepairer((ITokenScanner)new StringTokenScanner(new TextAttribute(resourceManager.createColor(new RGB(42, 0, 255)), null, 0, font)));
        this.setDamager((IPresentationDamager)dr, "STRING");
        this.setRepairer((IPresentationRepairer)dr, "STRING");
        dr = new DefaultDamagerRepairer(SCLPresentationReconciler.getSclTokenScanner(resourceManager));
        this.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        this.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
    }

    private static ITokenScanner getSclTokenScanner(ResourceManager resourceManager) {
        RuleBasedScanner scanner = new RuleBasedScanner();
        Token defaultToken = new Token((Object)new TextAttribute(resourceManager.createColor(new RGB(0, 0, 0)), null, 0, resourceManager.createFont(FONT_NORMAL)));
        Token reserved = new Token((Object)new TextAttribute(resourceManager.createColor(new RGB(127, 0, 85)), null, 1, resourceManager.createFont(FONT_BOLD)));
        WordRule reservedWord = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '_' || c == '?';
            }

            public boolean isWordPart(char c) {
                return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.' || c == '\'';
            }
        }, (IToken)defaultToken);
        String[] stringArray = SCLInfo.RESERVED_WORDS;
        int n = SCLInfo.RESERVED_WORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            reservedWord.addWord(word, (IToken)reserved);
            ++n2;
        }
        scanner.setRules(new IRule[]{new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return c == ' ' || c == '\t' || c == '\n' || c == '\r';
            }
        }, (IToken)defaultToken), reservedWord});
        scanner.setDefaultReturnToken((IToken)defaultToken);
        return scanner;
    }
}

