/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.writer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.event.util.EventWriteData;
import org.simantics.event.writer.EventSourceResolver;
import org.simantics.event.writer.EventWriteTask;

public class EventWriterJob
extends DatabaseJob {
    private final boolean DEBUG = false;
    private static final int WRITE_SCHEDULE_PERIOD = 1000;
    private static final long MIN_QUEUE_QUIET_TIME = 1000L;
    private static final long MIN_WRITE_QUIET_TIME = 1000L;
    private static final int MAX_TASK_QUEUE_SIZE = 500;
    private static final EventWriteTask[] NONE = new EventWriteTask[0];
    private List<EventWriteTask> tasks = new ArrayList<EventWriteTask>();
    private VirtualGraph virtualGraph;
    private Resource eventLog;
    private EventSourceResolver resolver;
    private AtomicBoolean scheduled = new AtomicBoolean(false);
    private AtomicBoolean polling = new AtomicBoolean(true);
    private long lastWriteTime = Long.MIN_VALUE;
    private long lastQueueTime = Long.MIN_VALUE;

    public EventWriterJob(VirtualGraph virtualGraph, Resource eventLog, EventSourceResolver resolver) {
        super("Event Writer");
        this.setPriority(50);
        this.setUser(false);
        this.setSystem(false);
        this.virtualGraph = virtualGraph;
        this.eventLog = eventLog;
        this.resolver = resolver;
    }

    public void dispose() {
        this.polling.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(EventWriteTask task) {
        List<EventWriteTask> list = this.tasks;
        synchronized (list) {
            this.tasks.add(task);
            this.lastQueueTime = System.currentTimeMillis();
            if (this.scheduled.compareAndSet(false, true)) {
                this.schedule(1000L);
            }
        }
    }

    public boolean shouldRun() {
        return this.polling.get() && Simantics.peekSession() != null;
    }

    /*
     * Loose catch block
     */
    protected IStatus run(final IProgressMonitor monitor) {
        try {
            boolean taskCountExceeded;
            Session session = Simantics.peekSession();
            if (session == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            int taskCount = this.countTasks();
            if (taskCount == 0) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            long currentTime = System.currentTimeMillis();
            if (this.lastWriteTime == Long.MIN_VALUE) {
                this.lastWriteTime = currentTime;
            }
            long queueQuietTime = currentTime - this.lastQueueTime;
            long writeQuietTime = currentTime - this.lastWriteTime;
            boolean queueQuietTimePassed = queueQuietTime >= 1000L;
            boolean writeQuietTimePassed = writeQuietTime >= 1000L;
            boolean bl = taskCountExceeded = taskCount >= 500;
            if (!(writeQuietTimePassed || queueQuietTimePassed || taskCountExceeded)) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            final EventWriteTask[] tasks = this.pruneTasks();
            if (tasks.length == 0) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.setThread(Thread.currentThread());
            monitor.beginTask("Flush Events", tasks.length);
            try {
                final EventWriteData writeData = (EventWriteData)session.syncRequest((Read)new UniqueRead<EventWriteData>(){

                    public EventWriteData perform(ReadGraph graph) throws DatabaseException {
                        return new EventWriteData(graph, EventWriterJob.this.eventLog, EventWriterJob.this.virtualGraph);
                    }
                });
                session.sync((WriteInterface)new WriteOnlyRequest(this.virtualGraph){

                    public void perform(WriteOnlyGraph graph) throws DatabaseException {
                        EventWriterJob.this.setThread(Thread.currentThread());
                        ArrayList<Resource> events = new ArrayList<Resource>(tasks.length);
                        EventWriteTask[] eventWriteTaskArray = tasks;
                        int n = tasks.length;
                        int n2 = 0;
                        while (n2 < n) {
                            EventWriteTask task = eventWriteTaskArray[n2];
                            writeData.prepareToWrite(graph);
                            Resource event = task.write(graph, writeData.targetSlice, writeData.targetPos);
                            if (event != null) {
                                events.add(event);
                                writeData.written();
                            }
                            monitor.worked(1);
                            ++n2;
                        }
                        writeData.commit(graph);
                        if (EventWriterJob.this.resolver != null) {
                            EventWriterJob.this.resolver.queueEvents(events);
                        }
                    }
                });
                this.lastWriteTime = System.currentTimeMillis();
            }
            catch (CancelTransactionException cancelTransactionException) {
                this.polling.set(false);
                IStatus iStatus = Status.CANCEL_STATUS;
                monitor.done();
                this.schedule(1000L);
                return iStatus;
            }
            catch (DatabaseException e) {
                Status status = new Status(4, "org.simantics.event", "Event writing failed", (Throwable)e);
                monitor.done();
                this.schedule(1000L);
                return status;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            monitor.done();
            this.schedule(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countTasks() {
        List<EventWriteTask> list = this.tasks;
        synchronized (list) {
            return this.tasks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventWriteTask[] pruneTasks() {
        List<EventWriteTask> list = this.tasks;
        synchronized (list) {
            EventWriteTask[] tasks = this.tasks.toArray(NONE);
            this.tasks.clear();
            return tasks;
        }
    }
}

