/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.writer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleObject;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.event.ontology.EventResource;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.MapList;

public class EventSourceResolver
extends DatabaseJob {
    private final boolean DEBUG = false;
    private final boolean DEBUG_DETAIL = false;
    private static final int RESOLUTION_SCHEDULE_PERIOD = 2000;
    public List<Resource> events = new ArrayList<Resource>();
    private boolean initialEventsResolved = false;
    private Resource eventLog;
    private Filter eventSourceFilter;
    private VirtualGraph virtualGraph;
    private AtomicBoolean polling = new AtomicBoolean(true);

    public EventSourceResolver(VirtualGraph virtualGraph, Resource eventLog, Filter eventSourceFilter) {
        super("Event Source Resolver");
        this.setPriority(50);
        this.setUser(false);
        this.setSystem(true);
        this.virtualGraph = virtualGraph;
        this.eventLog = eventLog;
        this.eventSourceFilter = eventSourceFilter;
    }

    public void dispose() {
        this.polling.set(false);
    }

    public boolean shouldRun() {
        return this.polling.get() && Simantics.peekSession() != null;
    }

    /*
     * Loose catch block
     */
    protected IStatus run(final IProgressMonitor monitor) {
        try {
            Session session = Simantics.peekSession();
            if (session == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            final Resource[] events = this.pruneEvents();
            if (events.length == 0 && this.initialEventsResolved) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.setThread(Thread.currentThread());
            monitor.beginTask("Resolve " + events.length + " events", events.length);
            try {
                session.sync((WriteInterface)new WriteRequest(this.virtualGraph){
                    Resource model;
                    Function indexFunction;
                    Layer0 L0;
                    Layer0X L0X;
                    EventResource EVENT;

                    public void perform(WriteGraph graph) throws DatabaseException {
                        EventSourceResolver.this.setThread(Thread.currentThread());
                        this.L0 = Layer0.getInstance((ReadGraph)graph);
                        this.L0X = Layer0X.getInstance((ReadGraph)graph);
                        this.EVENT = EventResource.getInstance((ReadGraph)graph);
                        Resource run = (Resource)graph.sync((ReadInterface)new PossibleObject(EventSourceResolver.this.eventLog, this.EVENT.HasEventProducer));
                        if (run == null) {
                            throw new CancelTransactionException();
                        }
                        if (!graph.hasStatement(run, SimulationResource.getInstance((ReadGraph)graph).IsActive)) {
                            throw new CancelTransactionException();
                        }
                        this.model = (Resource)graph.sync((ReadInterface)new PossibleObject(EventSourceResolver.this.eventLog, this.EVENT.IsEventLogOf));
                        if (this.model == null) {
                            throw new CancelTransactionException();
                        }
                        this.indexFunction = (Function)graph.adapt(this.L0X.Dependencies, Function.class);
                        if (!EventSourceResolver.this.initialEventsResolved) {
                            MapList initialEventsBySource = new MapList();
                            for (Resource slice : graph.getObjects(EventSourceResolver.this.eventLog, this.L0.ConsistsOf)) {
                                Collection initialEvents = (Collection)graph.syncRequest((Read)new ObjectsWithType(slice, this.L0.ConsistsOf, this.EVENT.Event));
                                MapList<String, Resource> bySource = this.sortEventsBySource((ReadGraph)graph, initialEvents);
                                for (String key : bySource.getKeys()) {
                                    initialEventsBySource.addAll((Object)key, (Collection)bySource.getValuesUnsafe((Object)key));
                                }
                            }
                            for (String sourceName : initialEventsBySource.getKeys()) {
                                this.resolveEvents(graph, sourceName, initialEventsBySource.getValuesUnsafe((Object)sourceName));
                            }
                            EventSourceResolver.this.initialEventsResolved = true;
                        }
                        MapList<String, Resource> eventsBySource = this.sortEventsBySource((ReadGraph)graph, Arrays.asList(events));
                        for (String sourceName : eventsBySource.getKeys()) {
                            this.resolveEvents(graph, sourceName, eventsBySource.getValuesUnsafe((Object)sourceName));
                            monitor.worked(1);
                        }
                    }

                    private MapList<String, Resource> sortEventsBySource(ReadGraph graph, Collection<Resource> events2) throws DatabaseException {
                        MapList result = new MapList();
                        for (Resource event : events2) {
                            String sourceName;
                            Collection sources = graph.getObjects(event, this.EVENT.Event_source);
                            if (!sources.isEmpty() || (sourceName = (String)graph.getPossibleRelatedValue(event, this.EVENT.Event_sourceName)) == null || sourceName.trim().isEmpty()) continue;
                            result.add((Object)sourceName, (Object)event);
                        }
                        return result;
                    }

                    private void resolveEvents(WriteGraph graph, String sourceName, Collection<Resource> eventsForSource) throws DatabaseException {
                        if (sourceName == null) {
                            throw new NullPointerException("null source name");
                        }
                        monitor.subTask("Resolve events with source " + sourceName);
                        List results = (List)this.indexFunction.apply((Object)graph, (Object)this.model, (Object)("Name:" + sourceName));
                        for (Map result : results) {
                            Resource rModel;
                            Resource r = (Resource)result.get("Resource");
                            if (EventSourceResolver.this.eventSourceFilter != null && !EventSourceResolver.this.eventSourceFilter.accept((ReadGraph)graph, r) || !this.model.equals(rModel = (Resource)graph.sync((ReadInterface)new PossibleModel(r)))) continue;
                            for (Resource event : eventsForSource) {
                                Resource otherEvent = this.resolveAndMarkEventPair(graph, r, event);
                                if (otherEvent == null) {
                                    graph.claim(event, this.EVENT.Event_source, this.EVENT.Event_source_inverse, r);
                                    continue;
                                }
                                graph.deny(otherEvent, this.EVENT.Event_source, this.EVENT.Event_source_inverse, r);
                                graph.claim(otherEvent, this.EVENT.Event_source, null, r);
                                graph.claim(event, this.EVENT.Event_source, null, r);
                            }
                        }
                    }

                    private Resource resolveAndMarkEventPair(WriteGraph graph, Resource source, Resource event) throws DatabaseException {
                        Integer eventIndex = (Integer)graph.getPossibleRelatedValue(event, this.EVENT.Event_index);
                        boolean returnEvent = graph.hasStatement(event, this.EVENT.ReturnEvent);
                        for (Resource otherEvent : graph.getObjects(source, this.EVENT.Event_source_inverse)) {
                            Integer index = (Integer)graph.getPossibleRelatedValue(otherEvent, this.EVENT.Event_index);
                            boolean ret = graph.hasStatement(otherEvent, this.EVENT.ReturnEvent);
                            if (index == null || !index.equals(eventIndex) || returnEvent == ret) continue;
                            if (returnEvent) {
                                graph.claim(event, this.EVENT.Returns, this.EVENT.ReturnedBy, otherEvent);
                            } else {
                                graph.claim(otherEvent, this.EVENT.Returns, this.EVENT.ReturnedBy, event);
                            }
                            return otherEvent;
                        }
                        return null;
                    }
                });
            }
            catch (CancelTransactionException cancelTransactionException) {
                this.polling.set(false);
                IStatus iStatus = Status.CANCEL_STATUS;
                monitor.done();
                this.schedule(2000L);
                return iStatus;
            }
            catch (DatabaseException e) {
                Status status = new Status(4, "org.simantics.event", "Event source resolution failed, see exception for details.", (Throwable)e);
                monitor.done();
                this.schedule(2000L);
                return status;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            monitor.done();
            this.schedule(2000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource[] pruneEvents() {
        List<Resource> list = this.events;
        synchronized (list) {
            Resource[] events = this.events.toArray(Resource.NONE);
            this.events.clear();
            return events;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvents(Collection<Resource> events) {
        List<Resource> list = this.events;
        synchronized (list) {
            this.events.addAll(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(Resource event) {
        List<Resource> list = this.events;
        synchronized (list) {
            this.events.add(event);
        }
    }

    public static interface Filter {
        public boolean accept(ReadGraph var1, Resource var2) throws DatabaseException;
    }
}

