/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.request.MultiRead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiReadEntry<T>
extends CacheEntryBase<SyncMultiProcedure<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiReadEntry.class);
    protected MultiRead<T> request;

    MultiReadEntry(MultiRead<T> request) {
        this.request = request;
    }

    @Override
    int makeHash() {
        return this.request.hashCode();
    }

    @Override
    public Object getOriginalRequest() {
        return this.request;
    }

    @Override
    public void discard() {
        super.discard();
        this.request = null;
        this.setResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finish(ReadGraph graph) {
        assert (this.isPending());
        MultiReadEntry multiReadEntry = this;
        synchronized (multiReadEntry) {
            this.setReady();
        }
    }

    @Override
    public final void clearResult(QuerySupport support) {
        this.setResult(new ArrayList());
    }

    public final synchronized void addOrSet(Object item) {
        assert (this.isPending());
        ArrayList value = (ArrayList)this.getResult();
        value.add(item);
    }

    @Override
    public final Query getQuery() {
        return new Query(){

            @Override
            public void recompute(ReadGraphImpl graph) {
                try {
                    MultiReadEntry.this.request.perform((ReadGraph)graph, new SyncMultiProcedure<T>(){

                        public void execute(ReadGraph graph, T result) {
                            MultiReadEntry.this.addOrSet(result);
                        }

                        public void finished(ReadGraph graph) {
                            MultiReadEntry.this.finish(graph);
                        }

                        public void exception(ReadGraph graph, Throwable t) {
                            MultiReadEntry.this.except(t);
                        }
                    });
                }
                catch (Throwable t) {
                    MultiReadEntry.this.except(t);
                }
            }

            @Override
            public void removeEntry(QueryProcessor processor) {
                processor.cache.remove(MultiReadEntry.this);
            }

            @Override
            public int type() {
                return 0;
            }

            public String toString() {
                if (MultiReadEntry.this.request == null) {
                    return "DISCARDED";
                }
                return String.valueOf(MultiReadEntry.this.request.toString()) + MultiReadEntry.this.statusOrException;
            }
        };
    }

    public void performFromCache(AsyncReadGraph graph, Object provider, Object procedure) {
        AsyncMultiProcedure proc = (AsyncMultiProcedure)procedure;
        if (this.isExcepted()) {
            try {
                proc.exception(graph, (Throwable)this.getResult());
            }
            catch (Throwable t) {
                LOGGER.error("performFromCache proc.exception failed", t);
            }
        } else {
            ArrayList values = (ArrayList)this.getResult();
            for (Object value : values) {
                try {
                    proc.execute(graph, value);
                }
                catch (Throwable t) {
                    LOGGER.error("performFromCache proc.execute failed", t);
                }
            }
            try {
                proc.finished(graph);
            }
            catch (Throwable t) {
                LOGGER.error("performFromCache proc.finished failed", t);
            }
        }
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, SyncMultiProcedure<T> proc) {
        if (this.isExcepted()) {
            try {
                proc.exception((ReadGraph)graph, (Throwable)this.getResult());
            }
            catch (Throwable t) {
                LOGGER.error("performFromCache(Sync) proc.exception failed", t);
            }
        } else {
            ArrayList values = (ArrayList)this.getResult();
            for (Object value : values) {
                try {
                    proc.execute((ReadGraph)graph, value);
                }
                catch (Throwable t) {
                    LOGGER.error("performFromCache(Sync) proc.execute failed", t);
                }
            }
            try {
                proc.finished((ReadGraph)graph);
            }
            catch (Throwable t) {
                LOGGER.error("performFromCache(Sync) proc.finished failed", t);
            }
        }
        return null;
    }

    public String toString() {
        if (this.request == null) {
            return "DISCARDED";
        }
        return String.valueOf(this.request.toString()) + this.statusOrException;
    }

    public Object compute(ReadGraphImpl graph, SyncMultiProcedure<T> procedure) throws DatabaseException {
        return graph.processor.cache.performQuery(graph, this.request, (CacheEntryBase)this, procedure);
    }
}

