/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.simantics.utils.FileUtils;

public class CodeGen {
    int indent = 4;
    String[] signatureR1RelationInfo = new String[]{"int r", "r", "keyR", "long", "InternalProcedure<RelationInfo>", "entry.id"};
    String[] signatureR1Bytes = new String[]{"int r", "r", "keyR", "long", "InternalProcedure<byte[]>", "entry.id"};
    String[] signatureR1IntSet = new String[]{"int r", "r", "keyR", "long", "InternalProcedure<IntSet>", "entry.id"};
    String[] signatureR1IP = new String[]{"int r", "r", "keyR", "long", "IntProcedure", "entry.id"};
    String[] signatureR2IP = new String[]{"int r1, int r2", "r1,r2", "keyR2", "long", "IntProcedure", "entry.id"};
    String[] signatureR2TIP = new String[]{"int r1, int r2", "r1,r2", "keyR2", "long", "TripleIntProcedure", "entry.id"};
    String[] signatureID1 = new String[]{"String id", "id", "keyID", "String", "InternalProcedure<Integer>", "entry.id"};
    String[] signatureID2 = new String[]{"String id", "id", "keyID", "String", "InternalProcedure<TObjectIntHashMap<String>>", "entry.id"};
    String[] signatureChildMap = new String[]{"int r", "r", "keyR", "long", "InternalProcedure<ObjectResourceIdMap<String>>", "entry.id"};
    String[] signatureRead = new String[]{"Read<?> r", "r", "id", "long", "AsyncProcedure", "entry.request"};
    String[] signatureAsyncRead = new String[]{"AsyncRead<?> r", "r", "id", "long", "AsyncProcedure", "entry.request"};
    String[] signatureMultiRead = new String[]{"MultiRead<?> r", "r", "id", "long", "SyncMultiProcedure", "entry.request"};
    String[] signatureAsyncMultiRead = new String[]{"AsyncMultiRead<?> r", "r", "id", "long", "AsyncMultiProcedure", "entry.request"};
    String[] signatureExternalRead = new String[]{"ExternalRead<?> r", "r", "id", "long", "AsyncProcedure", "entry.request"};

    private void line(StringBuilder content, String line) {
        int i = 0;
        while (i < this.indent) {
            content.append(" ");
            ++i;
        }
        content.append(line);
        content.append("\n");
    }

    public void generateQuery(StringBuilder content, String clazz, String[] signature, boolean runnerShortcut, boolean genReturn) {
        this.generateGetOrCreate(content, clazz, signature);
        this.generateRemove(content, clazz, signature);
        this.generateRunner(content, clazz, signature, runnerShortcut, genReturn);
    }

    public void generateRunner(StringBuilder content, String clazz, String[] signature, boolean shortcut, boolean genReturn) {
        this.line(content, "public static " + (genReturn ? "Object" : "void") + " runner" + clazz + "(ReadGraphImpl graph, " + signature[0] + ", CacheEntry parent, ListenerBase listener, final " + signature[4] + " procedure) throws DatabaseException {");
        this.line(content, "    QueryCache cache  = graph.processor.cache;");
        if (shortcut) {
            this.line(content, "    if(parent == null && listener == null && !cache.shouldCache(graph.processor, " + signature[1] + ")) {");
            this.line(content, "        if (SINGLE) {");
            this.line(content, "            " + clazz + " e = cache.peek" + clazz + "(" + signature[1] + ");");
            this.line(content, "            if (e != null && e.isReady()) {");
            this.line(content, "                " + (genReturn ? "return " : "") + "e.performFromCache(graph, procedure);");
            if (!genReturn) {
                this.line(content, "                return;");
            }
            this.line(content, "            }");
            this.line(content, "        }");
            this.line(content, "        " + (genReturn ? "return " : "") + clazz + ".computeForEach(graph, " + signature[1] + ", null, procedure);");
            if (!genReturn) {
                this.line(content, "        return;");
            }
            this.line(content, "    }");
        }
        this.line(content, "    " + clazz + " entry = (" + clazz + ")cache.getOrCreate" + clazz + "(graph, " + signature[1] + ");");
        this.line(content, "    " + signature[4] + " procedure_ = procedure != null ? procedure : emptyProcedure" + clazz + ";");
        this.line(content, "    ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);");
        this.line(content, "    if(entry.isReady()) " + (genReturn ? "return " : "") + "entry.performFromCache(graph, procedure_);");
        this.line(content, "    else {");
        this.line(content, "      assert(entry.isPending());");
        if (shortcut) {
            this.line(content, "      " + (genReturn ? "Object result = " : "") + clazz + ".computeForEach(graph, " + signature[1] + ", entry, procedure_);");
        } else {
            this.line(content, "      entry.compute(graph, procedure_);");
        }
        this.line(content, "      if(listenerEntry != null) cache.primeListenerEntry(listenerEntry, entry.getResult());");
        if (genReturn) {
            this.line(content, "      return result;");
        }
        this.line(content, "    }");
        this.line(content, "}");
        this.line(content, "");
        String lower = String.valueOf(Character.toLowerCase(clazz.charAt(0))) + clazz.substring(1);
        this.line(content, "private " + clazz + " peek" + clazz + "(" + signature[0] + ") {");
        this.line(content, "    synchronized(" + lower + "Map) {");
        this.line(content, "        return (" + clazz + ") " + lower + "Map.get(" + signature[1] + ");");
        this.line(content, "    }");
        this.line(content, "}");
        this.line(content, "");
    }

    public void generateRemove(StringBuilder content, String clazz, String[] signature) {
        String lower = String.valueOf(Character.toLowerCase(clazz.charAt(0))) + clazz.substring(1);
        this.line(content, "void remove(" + clazz + " entry) {");
        this.line(content, "    synchronized(" + lower + "Map) {");
        this.line(content, "        " + lower + "Map.remove(" + signature[5] + ");");
        this.line(content, "    }");
        this.line(content, "}");
        this.line(content, "");
    }

    public void generateGetOrCreate(StringBuilder content, String clazz, String[] signature) {
        String lower = String.valueOf(Character.toLowerCase(clazz.charAt(0))) + clazz.substring(1);
        this.line(content, clazz + " getOrCreate" + clazz + "(ReadGraphImpl graph, " + signature[0] + ") throws DatabaseException {");
        this.line(content, "    " + clazz + " existing = null;");
        this.line(content, "    synchronized(" + lower + "Map) {");
        this.line(content, "        existing = (" + clazz + ")" + lower + "Map.get(" + signature[1] + ");");
        this.line(content, "        if(existing == null) {");
        this.line(content, "            existing = new " + clazz + "(" + signature[1] + ");");
        this.line(content, "            existing.clearResult(querySupport);");
        this.line(content, "            existing.setPending();");
        this.line(content, "            " + lower + "Map.put(" + signature[2] + "(" + signature[1] + "), existing);");
        this.line(content, "            size++;");
        this.line(content, "            return existing;");
        this.line(content, "        }");
        this.line(content, "        if(existing.requiresComputation()) {");
        this.line(content, "            existing.setPending();");
        this.line(content, "            return existing;");
        this.line(content, "        }");
        this.line(content, "    }");
        this.line(content, "    if(existing.isPending()) waitPending(graph, existing);");
        this.line(content, "    return existing;");
        this.line(content, "}");
        this.line(content, "");
    }

    public void generate() {
        URL classLocation = CodeGen.class.getResource(".");
        if (classLocation != null && classLocation.getProtocol().equals("file")) {
            try {
                URL resource = new URL(classLocation, ".");
                File path = new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
                String target = path.getAbsolutePath().replace("\\", "/");
                target = String.valueOf(target.replace("/bin/", "/src/")) + "/QueryCache.java";
                System.err.println("target=" + target);
                File source = new File(target);
                StringBuilder content = new StringBuilder();
                content.append("package org.simantics.db.impl.query;\n");
                content.append("\n");
                content.append("import org.simantics.db.ObjectResourceIdMap;\n");
                content.append("import org.simantics.db.RelationInfo;\n");
                content.append("import org.simantics.db.common.utils.Logger;\n");
                content.append("import org.simantics.db.exception.DatabaseException;\n");
                content.append("import org.simantics.db.impl.graph.ReadGraphImpl;\n");
                content.append("import org.simantics.db.impl.procedure.InternalProcedure;\n");
                content.append("import org.simantics.db.impl.query.QueryProcessor.SessionTask;\n");
                content.append("import org.simantics.db.procedure.AsyncMultiProcedure;\n");
                content.append("import org.simantics.db.procedure.AsyncProcedure;\n");
                content.append("import org.simantics.db.procedure.ListenerBase;\n");
                content.append("import org.simantics.db.procedure.SyncMultiProcedure;\n");
                content.append("import org.simantics.db.request.AsyncMultiRead;\n");
                content.append("import org.simantics.db.request.AsyncRead;\n");
                content.append("import org.simantics.db.request.ExternalRead;\n");
                content.append("import org.simantics.db.request.MultiRead;\n");
                content.append("import org.simantics.db.request.Read;\n");
                content.append("\n");
                content.append("public class QueryCache extends QueryCacheBase {\n");
                content.append("\n");
                this.line(content, "private static final boolean SINGLE = true;");
                content.append("\n");
                this.line(content, "public QueryCache(QuerySupport querySupport, int threads) {");
                this.line(content, "    super(querySupport, threads);");
                this.line(content, "}");
                content.append("\n");
                this.generateQuery(content, "Objects", this.signatureR2IP, true, false);
                this.generateQuery(content, "Statements", this.signatureR2TIP, true, false);
                this.generateQuery(content, "DirectObjects", this.signatureR2IP, true, false);
                this.generateQuery(content, "RelationInfoQuery", this.signatureR1RelationInfo, true, false);
                this.generateQuery(content, "URIToResource", this.signatureID1, true, false);
                this.generateQuery(content, "ValueQuery", this.signatureR1Bytes, true, false);
                this.generateQuery(content, "OrderedSet", this.signatureR1IP, true, false);
                this.generateQuery(content, "PrincipalTypes", this.signatureR1IP, true, false);
                this.generateQuery(content, "DirectPredicates", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "Predicates", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "ReadEntry", this.signatureRead, true, true);
                this.generateQuery(content, "AsyncReadEntry", this.signatureAsyncRead, true, true);
                this.generateQuery(content, "Types", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "ChildMap", this.signatureChildMap, true, false);
                this.generateQuery(content, "TypeHierarchy", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "SuperTypes", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "SuperRelations", this.signatureR1IntSet, true, false);
                this.generateQuery(content, "AssertedPredicates", this.signatureR1IP, false, false);
                this.generateQuery(content, "AssertedStatements", this.signatureR2TIP, false, false);
                this.generateQuery(content, "DirectSuperRelations", this.signatureR1IP, false, false);
                this.generateQuery(content, "MultiReadEntry", this.signatureMultiRead, false, false);
                this.generateQuery(content, "AsyncMultiReadEntry", this.signatureAsyncMultiRead, false, false);
                this.generateQuery(content, "ExternalReadEntry", this.signatureExternalRead, false, false);
                content.append("}\n");
                FileUtils.writeFile((File)source, (byte[])content.toString().getBytes());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        new CodeGen().generate();
    }
}

