/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.impl.graph.AsyncBarrierImpl;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.QueryProcessor;

public class BarrierTracing {
    public static final boolean BOOKKEEPING = false;
    static final boolean RESTART_GUARD = false;
    public static Map<QueryProcessor.SessionTask, Exception> tasks = new HashMap<QueryProcessor.SessionTask, Exception>();
    public static final HashMap<AsyncBarrierImpl, Collection<AsyncBarrierImpl>> reverseLookup = new HashMap();
    public static final HashMap<AsyncBarrierImpl, Debugger> debuggerMap = new HashMap();
    public static final HashMap<AsyncBarrierImpl, CacheEntry<?>> entryMap = new HashMap();
    public static final HashMap<AsyncBarrierImpl, Throwable> restartMap = new HashMap();
    public static final HashMap<AsyncBarrierImpl, Throwable> startMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace(AsyncBarrierImpl barrier, CacheEntry<?> entry) {
        HashMap<AsyncBarrierImpl, Object> hashMap = entryMap;
        synchronized (hashMap) {
            entryMap.put(barrier, entry);
        }
        hashMap = debuggerMap;
        synchronized (hashMap) {
            debuggerMap.put(barrier, new Debugger());
        }
        hashMap = reverseLookup;
        synchronized (hashMap) {
            Collection<AsyncBarrierImpl> barriers = reverseLookup.get(barrier.caller);
            if (barriers == null) {
                barriers = new ArrayList<AsyncBarrierImpl>();
                reverseLookup.put(barrier.caller, barriers);
            }
            barriers.add(barrier);
        }
    }

    public static void inc(AsyncBarrierImpl barrier) {
        barrier.inc(barrier, new Exception().getStackTrace()[2].toString());
    }

    public static void restart(AsyncBarrierImpl barrier) {
    }

    public static void dec(AsyncBarrierImpl barrier, int count) {
        if (count == 0) {
            debuggerMap.remove(barrier);
        } else if (count < 0) {
            startMap.get(barrier).printStackTrace();
            restartMap.get(barrier).printStackTrace();
            new Exception().printStackTrace();
        }
    }

    public static class Debugger {
        public Map<AsyncBarrierImpl, String> infos = new HashMap<AsyncBarrierImpl, String>();

        public synchronized void inc(AsyncBarrierImpl id, String info) {
            if (id == null) {
                return;
            }
            String exist = this.infos.get(id);
            if (exist != null) {
                throw new IllegalStateException("Already existing info " + id + " " + info);
            }
            this.infos.put(id, exist);
        }

        public synchronized void dec(AsyncBarrierImpl id) {
            if (id == null) {
                return;
            }
            String exist = this.infos.get(id);
            if (exist == null) {
                System.err.println("No data for " + id);
            } else {
                this.infos.remove(id);
            }
        }

        public synchronized String toString() {
            StringBuilder b = new StringBuilder();
            for (String s : this.infos.values()) {
                b.append("info " + s + "\r\n");
            }
            return b.toString();
        }

        public boolean isEmpty() {
            return this.infos.isEmpty();
        }
    }
}

