/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.mapping;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationException;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.BasicResources;
import org.simantics.diagram.synchronization.graph.CopyAdvisorUtil;
import org.simantics.diagram.synchronization.graph.GraphCopyAdvisor;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ComponentUtils;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.services.ComponentNamingUtil;
import org.simantics.modeling.services.NamingException;
import org.simantics.project.IProject;
import org.simantics.structural.stubs.StructuralResource2;

public class ComponentCopyAdvisor
extends GraphCopyAdvisor {
    public CopyAdvisor.Evaluation canCopy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        BasicResources br = (BasicResources)context.get(GraphSynchronizationHints.BASIC_RESOURCES);
        return graph.isInstanceOf(source, br.STR.Component) || graph.isInstanceOf(source, br.STR.Connection) ? CopyAdvisor.Evaluation.SUPPORTED : CopyAdvisor.Evaluation.NOT_SUPPORTED;
    }

    public Object copy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        return this.copy(context, graph, source, sourceContainer, targetContainer, (Map<Object, Object>)new THashMap());
    }

    public Object copy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer, Map<Object, Object> map) throws DatabaseException {
        StructuralResource2.getInstance((ReadGraph)graph);
        Resource copy = CopyAdvisorUtil.copy2((WriteGraph)graph, (Resource)source, null, map);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.hasStatement(sourceContainer, L0.ConsistsOf, source)) {
            graph.claim(targetContainer, L0.ConsistsOf, copy);
        }
        if (ModelingUtils.needsIdentifier((ReadGraph)graph, source)) {
            Layer0Utils.claimNewIdentifier((WriteGraph)graph, (Resource)copy, (boolean)false);
        }
        if (context.get(SynchronizationHints.NO_RENAME) == null) {
            ComponentCopyAdvisor.renameComponent(context, graph, source, copy, sourceContainer, targetContainer);
        }
        return copy;
    }

    public static String renameComponent(ISynchronizationContext context, WriteGraph graph, Resource source, Resource copy, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        return ComponentCopyAdvisor.renameComponent(context, graph, source, copy, sourceContainer, targetContainer, Layer0.getInstance((ReadGraph)graph).HasName);
    }

    public static String renameComponent(ISynchronizationContext context, WriteGraph graph, Resource source, Resource copy, Resource sourceContainer, Resource targetContainer, Resource nameProperty) throws DatabaseException {
        BasicResources br = (BasicResources)context.get(GraphSynchronizationHints.BASIC_RESOURCES);
        Resource sourceComponentType = graph.getPossibleType(source, br.STR.Component);
        if (sourceComponentType == null) {
            return null;
        }
        IProject project = (IProject)context.get(SynchronizationHints.PROJECT);
        if (project == null) {
            project = Simantics.getProject();
        }
        Resource configurationRoot = ComponentUtils.getCompositeConfigurationRoot((ReadGraph)graph, targetContainer);
        Resource composite = targetContainer;
        if (configurationRoot != null) {
            try {
                String name = ComponentNamingUtil.findFreshInstanceName((ReadGraph)graph, project, configurationRoot, composite, sourceComponentType);
                graph.claimLiteral(copy, nameProperty, (Object)name, (Binding)Bindings.STRING);
                return name;
            }
            catch (NamingException e) {
                throw new SynchronizationException((Throwable)e);
            }
        }
        return null;
    }

    public Object cut(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (sourceContainer.equals(targetContainer)) {
            return null;
        }
        if (graph.hasStatement(sourceContainer, L0.ConsistsOf, source)) {
            graph.deny(sourceContainer, L0.ConsistsOf, source);
            graph.claim(targetContainer, L0.ConsistsOf, source);
        }
        return source;
    }
}

