/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.bytes;

public class BEDouble {
    public static byte[] toBytes(double value) {
        byte[] array = new byte[8];
        long l = Double.doubleToRawLongBits(value);
        array[0] = (byte)(l & 0xFFL);
        array[1] = (byte)(l >> 8 & 0xFFL);
        array[2] = (byte)(l >> 16 & 0xFFL);
        array[3] = (byte)(l >> 24 & 0xFFL);
        array[4] = (byte)(l >> 32 & 0xFFL);
        array[5] = (byte)(l >> 40 & 0xFFL);
        array[6] = (byte)(l >> 48 & 0xFFL);
        array[7] = (byte)(l >> 56 & 0xFFL);
        return array;
    }

    public static void write(double value, byte[] array, int offset) {
        if (offset + 8 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        long l = Double.doubleToRawLongBits(value);
        array[0 + offset] = (byte)(l & 0xFFL);
        array[1 + offset] = (byte)(l >> 8);
        array[2 + offset] = (byte)(l >> 16);
        array[3 + offset] = (byte)(l >> 24);
        array[4 + offset] = (byte)(l >> 32);
        array[5 + offset] = (byte)(l >> 40);
        array[6 + offset] = (byte)(l >> 48);
        array[7 + offset] = (byte)(l >> 56);
    }

    public static void write(double value, byte[] array) {
        if (array.length < 8) {
            throw new IndexOutOfBoundsException();
        }
        long l = Double.doubleToRawLongBits(value);
        array[0] = (byte)(l & 0xFFL);
        array[1] = (byte)(l >> 8);
        array[2] = (byte)(l >> 16);
        array[3] = (byte)(l >> 24);
        array[4] = (byte)(l >> 32);
        array[5] = (byte)(l >> 40);
        array[6] = (byte)(l >> 48);
        array[7] = (byte)(l >> 56);
    }

    public static double toDouble(byte[] array, int offset) {
        if (offset + 8 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        return Double.longBitsToDouble((long)array[0 + offset] & 0xFFL | ((long)array[1 + offset] & 0xFFL) << 8 | ((long)array[2 + offset] & 0xFFL) << 16 | ((long)array[3 + offset] & 0xFFL) << 24 | ((long)array[4 + offset] & 0xFFL) << 32 | ((long)array[5 + offset] & 0xFFL) << 40 | ((long)array[6 + offset] & 0xFFL) << 48 | ((long)array[7 + offset] & 0xFFL) << 56);
    }

    public static double toDouble(byte[] array) {
        if (8 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        return Double.longBitsToDouble((long)array[0] & 0xFFL | ((long)array[1] & 0xFFL) << 8 | ((long)array[2] & 0xFFL) << 16 | ((long)array[3] & 0xFFL) << 24 | ((long)array[4] & 0xFFL) << 32 | ((long)array[5] & 0xFFL) << 40 | ((long)array[6] & 0xFFL) << 48 | ((long)array[7] & 0xFFL) << 56);
    }

    public static void main(String[] args) {
        System.out.println("min=4.9E-324 max=1.7976931348623157E308");
        double value = -123.123;
        byte[] array = BEDouble.toBytes(value);
        System.out.print(value);
        System.out.print(" = ");
        BEDouble.printByteArray(array);
        System.out.println();
        BEDouble.write(value, array, 0);
        System.out.print(value);
        System.out.print(" = ");
        BEDouble.printByteArray(array);
        System.out.println();
        BEDouble.write(value, array);
        System.out.print(value);
        System.out.print(" = ");
        BEDouble.printByteArray(array);
        System.out.println();
        value = BEDouble.toDouble(array, 0);
        BEDouble.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
        value = BEDouble.toDouble(array);
        BEDouble.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
    }

    public static void printByteArray(byte[] array) {
        int i = 0;
        while (i < array.length) {
            System.out.print(array[i] & 0xFF);
            if (i < array.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
    }
}

