/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.multileveldiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.multileveldiagram.TransitionDiagram;
import org.simantics.g2d.multileveldiagram.TransitionFunction;
import org.simantics.utils.datastructures.hints.IHintContext;

public class LayerComposition {
    public static final IHintContext.Key KEY_PHASE = new IHintContext.KeyOf(MorphPhase.class);
    TransitionFunction function = TransitionFunction.SIGMOID;
    ArrayList<Node> nodes = new ArrayList();
    ArrayList<IDiagram> diagrams = new ArrayList();
    MorphLevel[] levels = null;

    public void addLayer(IDiagram diagram, Double startZoom, Double endZoom) {
        assert (diagram != null);
        if (startZoom != null && endZoom != null) assert (startZoom < endZoom);
        assert (startZoom != null || endZoom != null);
        if (startZoom != null) {
            this.nodes.add(new Node(diagram, startZoom));
        }
        if (endZoom != null) {
            this.nodes.add(new Node(diagram, endZoom));
        }
        this.levels = null;
    }

    public void removeLayer(IDiagram diagram) {
        Iterator<Node> i = this.nodes.iterator();
        while (i.hasNext()) {
            Node n = i.next();
            if (n.diagram != diagram) continue;
            i.remove();
        }
        this.levels = null;
    }

    private void _buildZoomLevels() {
        this.diagrams.clear();
        Collections.sort(this.nodes);
        int c = this.nodes.size();
        ArrayList<MorphLevel> levels = new ArrayList<MorphLevel>(c + 1);
        MorphLevel prevZL = null;
        int i = 0;
        while (i <= c) {
            MorphLevel zl = new MorphLevel();
            if (i == 0) {
                zl.ud = this.nodes.get((int)0).diagram;
                zl.ld = this.nodes.get((int)0).diagram;
                zl.ul = -1.7976931348623157E308;
                zl.ll = this.nodes.get((int)0).level;
            } else if (i == c) {
                zl.ud = this.nodes.get((int)(c - 1)).diagram;
                zl.ld = this.nodes.get((int)(c - 1)).diagram;
                zl.ul = this.nodes.get((int)(c - 1)).level;
                zl.ll = Double.MAX_VALUE;
            } else {
                zl.ud = this.nodes.get((int)(i - 1)).diagram;
                zl.ld = this.nodes.get((int)i).diagram;
                zl.ul = this.nodes.get((int)(i - 1)).level;
                zl.ll = this.nodes.get((int)i).level;
            }
            if (prevZL != null && prevZL.ld == zl.ld && prevZL.ud == zl.ud) {
                prevZL.ll = Math.max(prevZL.ll, zl.ll);
                prevZL.ul = Math.min(prevZL.ul, zl.ul);
                zl = prevZL;
            } else {
                prevZL = zl;
                levels.add(zl);
            }
            if (i > 0) {
                this.nodes.get((int)(i - 1)).upper = prevZL;
                this.nodes.get((int)(i - 1)).lower = zl;
            }
            if (zl.ud != null && !this.diagrams.contains(zl.ud)) {
                this.diagrams.add(zl.ud);
            }
            if (zl.ld != null && !this.diagrams.contains(zl.ld)) {
                this.diagrams.add(zl.ld);
            }
            ++i;
        }
        this.levels = levels.toArray(new MorphLevel[levels.size()]);
    }

    public MorphLevel[] getMorphLevels() {
        if (this.levels == null) {
            this._buildZoomLevels();
        }
        return this.levels;
    }

    public MorphPhase getTransitionInfo(double zoomLevel) {
        if (this.levels == null) {
            this._buildZoomLevels();
        }
        MorphLevel zl = null;
        int i = 0;
        while (i < this.levels.length) {
            zl = this.levels[i];
            if (zl.isInLevel(zoomLevel)) break;
            ++i;
        }
        MorphPhase zp = new MorphPhase();
        zp.level = zl;
        if (zl.ld == null || zl.ud == null || zl.ld == zl.ud) {
            return zp;
        }
        zp.phase = (zoomLevel - zl.ul) / (zl.ll - zl.ul);
        zp.phase = this.function.f(zp.phase);
        if (zp.phase < 0.0) {
            zp.phase = 0.0;
        }
        if (zp.phase > 1.0) {
            zp.phase = 1.0;
        }
        return zp;
    }

    public void setTransitionFunction(TransitionFunction function) {
        this.function = function;
    }

    public TransitionFunction getFunction() {
        return this.function;
    }

    public List<IDiagram> getDiagrams() {
        if (this.levels == null) {
            this._buildZoomLevels();
        }
        return Collections.unmodifiableList(this.diagrams);
    }

    public String toString() {
        return this.getDiagrams().toString();
    }

    public List<LayerInfo> buildMorphLayers() {
        ArrayList<LayerInfo> result = new ArrayList<LayerInfo>();
        MorphLevel[] morphLevelArray = this.getMorphLevels();
        int n = morphLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            MorphLevel ml = morphLevelArray[n2];
            if (ml.ud != null && ml.ud == ml.ld) {
                LayerInfo li = new LayerInfo();
                li.diagram = ml.ud;
                li.ll = ml.ll;
                li.ul = ml.ul;
                result.add(li);
            } else {
                IDiagram ud = ml.ud == null ? Diagram.EMPTY_DIAGRAM : ml.ud;
                IDiagram ld = ml.ld == null ? Diagram.EMPTY_DIAGRAM : ml.ld;
                LayerInfo li = new LayerInfo();
                li.ll = ml.ll;
                li.ul = ml.ul;
                li.diagram = TransitionDiagram.createTransitionDiagram(ud, ld, TransitionDiagram.MORPH_ELEMENT_CLASS);
                result.add(li);
            }
            ++n2;
        }
        return result;
    }

    public static class LayerInfo {
        public double ul;
        public double ll;
        public IDiagram diagram;
    }

    public static class MorphLevel {
        public IDiagram ud;
        public IDiagram ld;
        public double ul;
        public double ll;
        public IDiagram diagram;

        public boolean isLocked() {
            return this.ud == this.ld;
        }

        public boolean isInTransition() {
            return this.ud != this.ld;
        }

        public boolean isInLevel(double zoomLevel) {
            return zoomLevel >= this.ul && zoomLevel <= this.ll;
        }

        public String toString() {
            String un = "[]";
            if (this.ud != null) {
                un = this.ud.toString();
            }
            String ln = "[]";
            if (this.ld != null) {
                ln = this.ld.toString();
            }
            return String.valueOf(un) + " .. " + ln;
        }
    }

    public static class MorphPhase {
        public MorphLevel level;
        public double phase;

        public String toString() {
            return String.valueOf(this.phase) + "\t" + this.level;
        }
    }

    private static class Node
    implements Comparable<Node> {
        double level;
        IDiagram diagram;
        MorphLevel upper;
        MorphLevel lower;

        @Override
        public int compareTo(Node n) {
            double diff = this.level - n.level;
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return 0;
        }

        public Node(IDiagram diagram, double level) {
            this.level = level;
            this.diagram = diagram;
        }
    }
}

