/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.canvas.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.g2d.canvas.IMouseCaptureContext;
import org.simantics.g2d.canvas.IMouseCaptureHandle;
import org.simantics.g2d.canvas.IMouseCaptureHandleListener;
import org.simantics.g2d.canvas.IMouseCaptureListener;
import org.simantics.g2d.canvas.impl.MouseCaptureHandle;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;

public class MouseCaptureContext
implements IMouseCaptureContext {
    protected Map<Integer, Set<IMouseCaptureHandle>> mouseCapture = new HashMap<Integer, Set<IMouseCaptureHandle>>();
    protected SyncListenerList<IMouseCaptureListener> mouseCaptureListeners = new SyncListenerList(IMouseCaptureListener.class);
    private static final Method onMouseCaptured = SyncListenerList.getMethod(IMouseCaptureListener.class, (String)"onMouseCaptured");
    private static final Method onMouseReleased = SyncListenerList.getMethod(IMouseCaptureListener.class, (String)"onMouseReleased");

    @Override
    public void addMouseCaptureListener(IMouseCaptureListener listener) {
        this.mouseCaptureListeners.add((Object)listener);
    }

    @Override
    public void addMouseCaptureListener(IMouseCaptureListener listener, IThreadWorkQueue thread) {
        this.mouseCaptureListeners.add(thread, (Object)listener);
    }

    @Override
    public void removeMouseCaptureListener(IMouseCaptureListener listener) {
        this.mouseCaptureListeners.remove((Object)listener);
    }

    @Override
    public void removeMouseCaptureListener(IMouseCaptureListener listener, IThreadWorkQueue thread) {
        this.mouseCaptureListeners.remove(thread, (Object)listener);
    }

    protected void fireMouseCaptured(int mouseId) {
        this.mouseCaptureListeners.fireEventSync(onMouseCaptured, new Object[]{this, mouseId});
    }

    protected void fireAsyncMouseCaptured(int mouseId) {
        this.mouseCaptureListeners.fireEventAsync(onMouseCaptured, new Object[]{this, mouseId});
    }

    protected void fireMouseReleased(int mouseId) {
        this.mouseCaptureListeners.fireEventSync(onMouseReleased, new Object[]{this, mouseId});
    }

    protected void fireAsyncMouseReleased(int mouseId) {
        this.mouseCaptureListeners.fireEventAsync(onMouseReleased, new Object[]{this, mouseId});
    }

    @Override
    public synchronized IMouseCaptureHandle captureMouse(int mouseId) {
        Set<IMouseCaptureHandle> captures = this.mouseCapture.get(mouseId);
        MouseCaptureHandle capture = new MouseCaptureHandle(mouseId);
        capture.addMouseCaptureHandleListener(new IMouseCaptureHandleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureReleased(IMouseCaptureHandle sender) {
                MouseCaptureContext mouseCaptureContext = MouseCaptureContext.this;
                synchronized (mouseCaptureContext) {
                    Set<IMouseCaptureHandle> captures = MouseCaptureContext.this.mouseCapture.get(sender.mouseId());
                    if (!captures.contains(this)) {
                        return;
                    }
                    captures.remove(this);
                    if (captures.isEmpty()) {
                        MouseCaptureContext.this.mouseCapture.remove(captures);
                        MouseCaptureContext.this.fireMouseReleased(sender.mouseId());
                    }
                }
            }
        });
        if (captures == null) {
            captures = new HashSet<IMouseCaptureHandle>();
            this.mouseCapture.put(mouseId, captures);
            this.fireMouseCaptured(mouseId);
        }
        captures.add(capture);
        return capture;
    }
}

