/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation;

public class IndexQueries {
    private static final String[] RESERVED_WORDS = new String[]{"AND", "\\AND", "OR", "\\OR", "NOT", "\\NOT"};

    public static String escape(String s, boolean escapeWildcards) {
        return IndexQueries.escape(s, escapeWildcards, true);
    }

    public static String escape(String s, boolean escapeWildcards, boolean escapeKeywords) {
        if (!IndexQueries.needsEscaping(s, escapeWildcards, escapeKeywords)) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 8);
        int len = s.length();
        boolean lastWhitespace = true;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '|' || c == '&' || c == '/' || c == ' ' || escapeWildcards && (c == '*' || c == '?')) {
                sb.append('\\');
                sb.append(c);
                lastWhitespace = false;
            } else if (Character.isWhitespace(c)) {
                sb.append(c);
                lastWhitespace = true;
            } else {
                int reslen;
                if (escapeKeywords && lastWhitespace && (reslen = IndexQueries.processReservedWords(s, i, sb)) > 0) {
                    i += reslen;
                    lastWhitespace = false;
                    continue;
                }
                sb.append(c);
                lastWhitespace = false;
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean needsEscaping(String s, boolean escapeWildcards, boolean escapeKeywords) {
        int len = s.length();
        boolean lastWhitespace = true;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '|' || c == '&' || c == '/' || c == ' ' || escapeWildcards && (c == '*' || c == '?')) {
                return true;
            }
            if (Character.isWhitespace(c)) {
                lastWhitespace = true;
            } else {
                int reslen;
                if (escapeKeywords && lastWhitespace && (reslen = IndexQueries.processReservedWords(s, i, null)) > 0) {
                    return true;
                }
                lastWhitespace = false;
            }
            ++i;
        }
        return false;
    }

    private static int processReservedWords(String s, int fromIndex, StringBuilder sb) {
        int total = RESERVED_WORDS.length;
        int w = 0;
        while (w < total) {
            String word = RESERVED_WORDS[w];
            int len = word.length();
            if (s.regionMatches(false, fromIndex, word, 0, len)) {
                if (sb != null) {
                    String replacement = RESERVED_WORDS[w + 1];
                    sb.append(replacement);
                }
                return len;
            }
            w += 2;
        }
        return 0;
    }

    public static String escape(String s) {
        return IndexQueries.escape(s, false);
    }

    public static StringBuilder escapeTerm(String field, String term, boolean escapeWildcards, StringBuilder result) {
        if (field != null) {
            result.append(field).append(':');
        }
        result.append(IndexQueries.escape(term, escapeWildcards));
        return result;
    }

    public static String escapeTerm(String field, String term, boolean escapeWildcards) {
        StringBuilder sb = new StringBuilder();
        return IndexQueries.escapeTerm(field, term, escapeWildcards, sb).toString();
    }

    public static String quoteTerm(String term) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(term.replaceAll("(\"|\\\\)", "\\\\$0"));
        sb.append("\"");
        return sb.toString();
    }
}

