/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.ge;

import org.eclipse.jface.resource.FontDescriptor;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.ui.AdaptionUtils;

public class SeriesLabelDecorationRule
implements LabelDecorationRule {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        String[] filter;
        Resource resource = (Resource)AdaptionUtils.adaptToSingle((Object)content, Resource.class);
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        if (resource != null && graph.isInstanceOf(resource, jfree.Series) && (filter = (String[])graph.getPossibleRelatedValue(resource, jfree.variableFilter, (Binding)Bindings.STRING_ARRAY)) != null) {
            return new LabelDecorator.Stub(){

                public String decorateLabel(String label, String column, int itemIndex) {
                    label = String.valueOf(label) + " [";
                    int i = 0;
                    while (i < filter.length) {
                        label = String.valueOf(label) + filter[i];
                        if (i < filter.length - 1) {
                            label = String.valueOf(label) + ", ";
                        }
                        ++i;
                    }
                    label = String.valueOf(label) + "]";
                    return label;
                }

                public <F> F decorateFont(F font, String column, int itemIndex) {
                    return (F)((FontDescriptor)font);
                }
            };
        }
        return null;
    }
}

