/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions.e4;

import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ui.actions.style.EditStyle;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class EditStyleHandler {
    private Resource[] lastResources = Resource.NONE;
    private boolean cachedCanExecute;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection s, @Active MPart part) throws DatabaseException, InterruptedException {
        if (!(part.getObject() instanceof CompatibilityEditor)) {
            return false;
        }
        CompatibilityEditor editor = (CompatibilityEditor)part.getObject();
        if (!(editor.getPart() instanceof DiagramEditor)) {
            return false;
        }
        if (s == null) {
            return false;
        }
        if (DatabaseJob.inProgress()) {
            return false;
        }
        Object[] resources = ResourceAdaptionUtils.toResources((Object)s);
        if (resources.length != 0) {
            if (!Arrays.equals(resources, this.lastResources)) {
                this.lastResources = resources;
                this.cachedCanExecute = EditStyleHandler.areStyleProviders((Resource[])resources);
            }
            return this.cachedCanExecute;
        }
        return false;
    }

    private static boolean areStyleProviders(Resource[] resources) throws DatabaseException, InterruptedException {
        return (Boolean)RequestUtil.trySyncRequest((Session)Simantics.getSession(), (long)SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT, (long)SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT, (Object)false, (Read)new StyleProviderCheck(Arrays.asList(resources)));
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") ISelection s) {
        Resource[] resources = ResourceAdaptionUtils.toResources((Object)s);
        if (resources.length != 0) {
            EditStyle.openStyleDialog(resources);
        }
    }

    private static class StyleProviderCheck
    extends UnaryRead<List<Resource>, Boolean> {
        public StyleProviderCheck(List<Resource> parameter) {
            super(parameter);
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            for (Resource r : (List)this.parameter) {
                if (graph.isInstanceOf(r, DIA.StyleProvider)) continue;
                return false;
            }
            return true;
        }
    }
}

