/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.actions.Messages;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class SetInitialState
extends DynamicMenuContribution {
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.dispose();
    }

    protected boolean preAcceptSelection(Object[] selection) {
        return selection != null && selection.length == 1;
    }

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        IExperimentManager expMan;
        if (selection.length != 1) {
            return NONE;
        }
        final Resource experiment = ResourceAdaptionUtils.adaptToResource((Object)selection[0]);
        if (experiment == null) {
            return NONE;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(experiment, SIMU.Experiment)) {
            return NONE;
        }
        IProject project = Simantics.peekProject();
        if (project != null && (expMan = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER)) != null) {
            IExperiment[] iExperimentArray = new IExperiment[]{expMan.getActiveExperiment()};
            int n = iExperimentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExperiment exp = iExperimentArray[n2];
                if (exp != null && experiment.equals(exp.getResource())) {
                    return NONE;
                }
                ++n2;
            }
        }
        final ArrayList<NamedResource> states = new ArrayList<NamedResource>();
        Resource model = graph.getSingleObject(experiment, L0.PartOf);
        for (Resource obj : (Collection)graph.syncRequest((Read)new ObjectsWithType(model, L0.ConsistsOf, SIMU.State))) {
            String name = (String)graph.adapt(obj, String.class);
            states.add(new NamedResource(name, obj));
        }
        final AtomicReference<NamedResource> currentInitialState = new AtomicReference<NamedResource>();
        Resource currentState = graph.getPossibleObject(experiment, SIMU.HasInitialState);
        if (currentState != null) {
            for (NamedResource state : states) {
                if (!state.getResource().equals(currentState)) continue;
                currentInitialState.set(state);
            }
        }
        Collections.sort(states);
        if (states.isEmpty()) {
            return NONE;
        }
        return new IContributionItem[]{new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem setInitialState = new MenuItem(menu, 64, index);
                setInitialState.setText(Messages.SetInitialState_SetInitialState);
                Menu subMenu = new Menu(menu);
                setInitialState.setMenu(subMenu);
                for (NamedResource state : states) {
                    SetInitialState.this.addMenuItem(subMenu, new Adapter(experiment, state), state.equals(currentInitialState.get()));
                }
            }
        }};
    }

    private void addMenuItem(Menu subMenu, Adapter adapter, boolean selected) {
        MenuItem item = new MenuItem(subMenu, 32);
        item.setText(adapter.getText());
        item.setSelection(selected);
        ImageDescriptor imgDesc = adapter.getImageDescriptor();
        if (imgDesc != null) {
            item.setImage(this.resourceManager.createImage(imgDesc));
        }
        item.addSelectionListener((SelectionListener)adapter);
    }

    static class Adapter
    extends Action
    implements SelectionListener {
        private final Resource experiment;
        private final NamedResource state;

        public Adapter(Resource experiment, NamedResource state) {
            super(state.getName());
            this.experiment = experiment;
            this.state = state;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.run();
        }

        public void run() {
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph wg) throws DatabaseException {
                    SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)wg);
                    wg.deny(experiment, SIMU.HasInitialState);
                    wg.claim(experiment, SIMU.HasInitialState, state.getResource());
                }
            });
        }
    }
}

