/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphfile.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandlerAdapter;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graphfile.adapters.SystemResourcePasteImportAdvisor;
import org.simantics.utils.datastructures.hints.IHintContext;

public class SystemResourcePasteHandler
extends PasteHandlerAdapter {
    private Resource resource;

    public SystemResourcePasteHandler(Resource resource) {
        this.resource = resource;
    }

    public static void defaultExecute(TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException, TransferableGraphException {
        TransferableGraphs.importGraph1((Session)Simantics.getSession(), (TransferableGraph1)tg, (IImportAdvisor)advisor);
    }

    public static void defaultExecute(WriteGraph graph, TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException {
        TransferableGraphs.importGraph1((WriteGraph)graph, (TransferableGraph1)tg, (IImportAdvisor)advisor);
    }

    public void execute(WriteGraph graph, TransferableGraph1 tg, Resource resource, IImportAdvisor advisor) throws DatabaseException {
        SystemResourcePasteHandler.defaultExecute(graph, tg, resource, advisor);
    }

    public void onPasteBegin(WriteGraph graph) throws DatabaseException {
    }

    public void onPaste(WriteGraph graph, SystemResourcePasteImportAdvisor advisor, Set<SimanticsClipboard.Representation> representations) throws DatabaseException {
        advisor.attachRoot(graph);
    }

    public void onPasteEnd(WriteGraph graph) throws DatabaseException {
    }

    public Collection<Resource> pasteObject(WriteGraph graph, Set<SimanticsClipboard.Representation> object) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, object, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
        if (tg != null) {
            SystemResourcePasteImportAdvisor advisor = new SystemResourcePasteImportAdvisor((ReadGraph)graph, this.resource);
            this.execute(graph, tg, this.resource, advisor);
            result.add(advisor.getRoot());
            try {
                this.onPaste(graph, advisor, object);
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public Collection<Resource> pasteFromClipboard(WriteGraph graph, SimanticsClipboard clipboard, PasteEventHandler handler) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        try {
            this.onPasteBegin(graph);
        }
        catch (Throwable throwable) {}
        HashSet cuts = new HashSet();
        for (Set object : clipboard.getContents()) {
            result.addAll(this.pasteObject(graph, object));
            Collection cut = (Collection)ClipboardUtils.accept((Set)object, (IHintContext.Key)SimanticsKeys.KEY_CUT_RESOURCES);
            if (cut == null) continue;
            cuts.addAll(cut);
        }
        try {
            this.onPasteEnd(graph);
        }
        catch (Throwable throwable) {}
        if (!cuts.isEmpty()) {
            for (Resource cut : cuts) {
                RemoverUtil.remove((WriteGraph)graph, (Resource)cut);
            }
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (Resource.class == adapter) {
            return this.resource;
        }
        return null;
    }
}

