/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.menu;

import java.awt.Color;
import java.awt.Font;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.sysdyn.ui.properties.widgets.CustomFontDialog;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class FontContextMenuContribution
extends DynamicMenuContribution {
    protected IContributionItem[] getContributionItems(final ReadGraph graph, Object[] selection) throws DatabaseException {
        if (selection.length == 0) {
            return new IContributionItem[0];
        }
        return new IContributionItem[]{new ContributionItem(){

            public void fill(Menu menu, int index) {
                Resource element;
                Object o;
                int n;
                int n2;
                Object[] objectArray;
                G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
                Object[] selections = FontContextMenuContribution.this.getSelectedObjects();
                Font font = null;
                Color color = null;
                try {
                    objectArray = selections;
                    n2 = selections.length;
                    n = 0;
                    while (n < n2) {
                        Resource fontResource;
                        o = objectArray[n];
                        element = ResourceAdaptionUtils.adaptToResource((Object)o);
                        if (element != null && (fontResource = graph.getPossibleObject(element, G2D.HasFont)) != null) {
                            Font newFont = G2DUtils.getFont((ReadGraph)graph, (Resource)fontResource);
                            if (font == null) {
                                font = newFont;
                            }
                            if (font != null && !font.equals(newFont)) {
                                font = null;
                                break;
                            }
                        }
                        ++n;
                    }
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                try {
                    objectArray = selections;
                    n2 = selections.length;
                    n = 0;
                    while (n < n2) {
                        Resource colorResource;
                        o = objectArray[n];
                        element = ResourceAdaptionUtils.adaptToResource((Object)o);
                        if (element != null && (colorResource = graph.getPossibleObject(element, G2D.HasColor)) != null) {
                            Color newColor = G2DUtils.getColor((ReadGraph)graph, (Resource)colorResource);
                            if (color == null) {
                                color = newColor;
                            }
                            if (color != null && !color.equals(newColor)) {
                                color = null;
                                break;
                            }
                        }
                        ++n;
                    }
                }
                catch (DatabaseException o2) {
                    // empty catch block
                }
                MenuItem item = new MenuItem(menu, 8);
                item.setText("Font...");
                item.addSelectionListener((SelectionListener)new FontSelectionListener(selections, font, color));
            }
        }};
    }

    class FontSelectionListener
    implements SelectionListener {
        private Font font;
        private Color color;
        private Object[] selections;

        public FontSelectionListener(Object[] selections, Font font, Color color) {
            this.selections = selections;
            this.font = font;
            this.color = color;
        }

        public void widgetSelected(SelectionEvent e) {
            CustomFontDialog dialog = new CustomFontDialog(e.widget.getDisplay().getActiveShell(), "Sample");
            if (this.font != null) {
                dialog.setAWTFont(this.font);
            }
            if (this.color != null) {
                dialog.setColor(this.color);
            }
            dialog.open();
            final Font resultFont = dialog.getAWTFont();
            final Color resultColor = dialog.getAWTColor();
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
                    Object[] objectArray = FontSelectionListener.this.selections;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        Resource element = ResourceAdaptionUtils.adaptToResource((Object)o);
                        if (resultFont != null) {
                            graph.deny(element, G2D.HasFont);
                            graph.claim(element, G2D.HasFont, G2DUtils.createFont((WriteGraph)graph, (Font)resultFont));
                        }
                        if (resultColor != null) {
                            graph.deny(element, G2D.HasColor);
                            graph.claim(element, G2D.HasColor, G2DUtils.createColor((WriteGraph)graph, (Color)resultColor));
                        }
                        ++n2;
                    }
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

