/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.exports;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.utils.imports.ImportUtilsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ExportFunctionLibrary
extends AbstractHandler {
    public static Object handleStatic(Resource functionLibrary) throws ExecutionException {
        Shell shell = WorkbenchUtils.getActiveWorkbenchWindowShell();
        return ExportFunctionLibrary.executeImpl(functionLibrary, shell);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Resource functionLibrary = ResourceAdaptionUtils.toSingleResource((Object)sel);
        if (functionLibrary == null) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        return ExportFunctionLibrary.executeImpl(functionLibrary, shell);
    }

    private static Object executeImpl(final Resource functionLibrary, Shell shell) throws ExecutionException {
        String name = null;
        try {
            name = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    if (!graph.hasStatement(functionLibrary, Layer0.getInstance((ReadGraph)graph).PartOf)) {
                        return null;
                    }
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    String name = (String)graph.syncRequest((Read)new PossibleRelatedValue(functionLibrary, l0.HasName, (Binding)Bindings.STRING));
                    return name;
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        if (name == null) {
            return null;
        }
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText("Export Function Library");
        fd.setFileName(name);
        String path = Activator.getDefault().getPreferenceStore().getString(ImportUtilsUI.IMPORTFUNCTIONLIBRARYPATH);
        if (path.isEmpty() || !new File(path).exists()) {
            path = Platform.getLocation().toOSString();
        }
        fd.setFilterPath(path);
        String[] filterExt = new String[]{"*.sysdynFunctions"};
        fd.setFilterExtensions(filterExt);
        fd.setOverwrite(true);
        final String selected = fd.open();
        if (selected == null) {
            return null;
        }
        Activator.getDefault().getPreferenceStore().setValue(ImportUtilsUI.IMPORTFUNCTIONLIBRARYPATH, new File(selected).getParent());
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                TransferableGraphConfiguration2 conf = new TransferableGraphConfiguration2(graph, functionLibrary);
                TransferableGraphSource s = (TransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf));
                try {
                    TransferableGraphs.writeTransferableGraph((RequestProcessor)graph, (String)"sysdynFunctionLibrary", (int)1, (TransferableGraphSource)s, (File)new File(selected));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return null;
    }
}

