/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.dialogs;

import java.util.Comparator;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.utils.datastructures.Pair;

public abstract class ResourceSelectionDialog2<T> extends FilteredItemsSelectionDialog {

    Map<T, Pair<String, Image>> nameMap;
    String title;

    class ResourceSelectionHistory extends FilteredItemsSelectionDialog.SelectionHistory {

        @Override
        protected Object restoreItemFromMemento(IMemento memento) {
            // FIXME: somehow create a collective transaction inside which the Graph.getRandomAccessReference should be invoked.
//            Resource r = Simantics.getSession().getRandomAccessReference(memento.getTextData());
//            return r;
            return null;
        }

        @Override
        protected void storeItemToMemento(Object item, IMemento memento) {
            if(item instanceof Resource) {
                try {
                    SerialisationSupport support = Simantics.getSession().getService(SerialisationSupport.class);
                    memento.putTextData(support.getResourceSerializer().createRandomAccessId((Resource)item));
                } catch (InvalidResourceReferenceException e) {
                    e.printStackTrace();
                }
            }
        }
        
    };

    public ResourceSelectionDialog2(Shell shell, Map<T, Pair<String, Image>> parameter, String title) {
        this(shell, parameter, title, true);
    }

    public ResourceSelectionDialog2(Shell shell, Map<T, Pair<String, Image>> parameter, String title, boolean multi) {
        super(shell, multi);
        this.nameMap = parameter;
        this.title = title;

        ILabelProvider labelProvider = new LabelProvider() {
            @Override
            public String getText(Object element) {
                Pair<String, Image> pair = nameMap.get(element);
                if(pair != null) return pair.first;
                else return null;
            }
            @Override
            public Image getImage(Object element) {
                Pair<String, Image> pair = nameMap.get(element);
                if(pair != null) return pair.second;
                else return null;
            }
        }; 

        setListLabelProvider(labelProvider);
        setDetailsLabelProvider(labelProvider);

        setSelectionHistory(new ResourceSelectionHistory());
        setTitle(title);
    }

    @Override
    protected Control createExtendedContentArea(Composite parent) {
        // Don't create anything extra at the moment
        return null;
    }

    class ResourceSelectionDialogItemsFilter extends FilteredItemsSelectionDialog.ItemsFilter {
        
        public ResourceSelectionDialogItemsFilter() {
            String patternText = getPattern();
            patternMatcher = new SearchPattern();
            if(patternText != null && patternText.length() > 0)
                patternMatcher.setPattern(patternText);
            else 
                patternMatcher.setPattern("*");
        }

        @Override
        public boolean isConsistentItem(Object item) {
            return true;
        }

        @Override
        public boolean matchItem(Object item) {
            return matches(nameMap.get(item).first);
        }
    }

    @Override
    protected ItemsFilter createFilter() {
        return new ResourceSelectionDialogItemsFilter();
    }

    @Override
    protected void fillContentProvider(AbstractContentProvider contentProvider,
            ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for(T o : nameMap.keySet())
            contentProvider.add(o, itemsFilter);
        if (progressMonitor != null)
            progressMonitor.done();
    }

    protected abstract IDialogSettings getBaseDialogSettings();

    @Override
    protected IDialogSettings getDialogSettings() {
        IDialogSettings base = getBaseDialogSettings();
        IDialogSettings settings = base.getSection(title);
        if (settings == null)
            settings = base.addNewSection(title);
        return settings;
    }

    @Override
    public String getElementName(Object item) {
        return nameMap.get(item).first;
    }

    @Override
    protected Comparator<?> getItemsComparator() {
        return new Comparator<Object>() {

            @Override
            public int compare(Object o1, Object o2) {
                return nameMap.get(o1).first.compareToIgnoreCase(nameMap.get(o2).first);
            }
            
        };
    }

    @Override
    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    /**
     * Made publicly visible.
     * @see org.eclipse.ui.dialogs.FilteredItemsSelectionDialog#updateStatus(org.eclipse.core.runtime.IStatus)
     */
    @Override
    public void updateStatus(IStatus status) {
        super.updateStatus(status);
    }

}
