/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.action;

import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.simantics.db.Resource;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.action.PriorityAction;

/**
 * @author Tuukka Lehtonen
 */
public class ResourceEditorAdapterAction extends PriorityAction {

    private static final boolean DEBUG = false;

    protected EditorAdapter      adapter;

    protected Object             resource;

    public ResourceEditorAdapterAction(EditorAdapter adapter, Object r) {
        super(makeName(adapter), adapter.getIcon());
        this.adapter = adapter;
        this.resource = r;
    }

    public static String makeName(EditorAdapter adapter) {
        if (DEBUG) {
            return adapter.getName() + " (" + adapter.getClass().getName() + ")[" + adapter.getPriority() + "]";
        }
        return adapter.getName();
    }

    @Override
    public final void run() {
        SafeRunner.run(new SafeRunnable() {
            @Override
            public void run() throws Exception {
                safeRun();
            }
        });
    }

    protected void safeRun() throws Exception {
        adapter.openEditor(resource);
    }

    public EditorAdapter getAdapter() {
        return adapter;
    }

    public Object getResource() {
        return resource;
    }

    @Override
    public int getPriority() {
        return adapter.getPriority();
    }

    public static IPriorityAction[] toActions(EditorAdapter[] adapters, Resource forResource) {
        IPriorityAction[] actions = new IPriorityAction[adapters.length];
        for (int i = 0; i < adapters.length; ++i) {
            actions[i] = new ResourceEditorAdapterAction(adapters[i], forResource);
        }
        return actions;
    }

}
