/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.action;

import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.simantics.db.Resource;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.ui.action.PriorityAction;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * A convenience implementation of IPriorityAction for opening a specified
 * workbench EditorPart.
 * 
 * @author Tuukka Lehtonen
 */
public class OpenEditorAction extends PriorityAction {

    String   editorId;

    Resource r;

    public OpenEditorAction(int priority, String text, ImageDescriptor imgDesc, String editorId, Resource r) {
        super(priority, text, imgDesc);
        this.editorId = editorId;
        this.r = r;
    }

    @Override
    public void run() {
        SafeRunner.run(new SafeRunnable() {
            @Override
            public void run() throws Exception {
                WorkbenchUtils.openEditor(editorId, new ResourceEditorInput(editorId, r));
            }
        });
    }
}
