package org.simantics.ui.colors;

import org.simantics.common.color.Color;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class RGBColor implements Color {
	
	double r,g,b;

	public RGBColor(double r, double g, double b) {
		this.r = r; this.g = g; this.b=b;
	}
	
	public RGBColor(ReadGraph graph, Resource resource) throws DatabaseException {
		double[] array = graph.getValue(resource, Bindings.DOUBLE_ARRAY);
		assert(array.length == 3);
		r = array[0];
		g = array[1];
		b = array[2];
	}

	@Override
	public double getR() {
		return r;
	}

	@Override
	public double getG() {
		return g;
	}

	@Override
	public double getB() {
		return b;
	}

	@Override
	public double getA() {
		throw new UnsupportedOperationException();
	}

	@Override
	public double getH() {
		throw new UnsupportedOperationException();
	}

	@Override
	public double getS() {
		throw new UnsupportedOperationException();
	}

	@Override
	public double getV() {
		throw new UnsupportedOperationException();
	}
	
}

