/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.trend.impl;

import java.awt.Color;

public class JarisPaints {
	
	public static final Color[] JarisPaintSequence;
	public static final String[] JarisPaintName;

	/**
	 * Get color. First color ( blue ) is 1.
	 * @param paintIndex
	 * @return
	 */
	public static Color getColor( int paintIndex )
	{
		return JarisPaintSequence[ modulus(paintIndex-1, JarisPaintSequence.length) ];
	}
	
	public static int modulus( int a, int b )
	{
		return a>=0? a%b : (((a%b)+b)%b);
	}

	static {
	    JarisPaintSequence = new Color[] {
	            new Color(0.00f, 0.00f, 1.00f),
	            new Color(0.00f, 0.50f, 0.00f),
	            new Color(1.00f, 0.00f, 0.00f),
	            new Color(0.00f, 0.75f, 0.75f),
	            new Color(0.75f, 0.00f, 0.75f),
	            new Color(0.40f, 0.40f, 0.00f), // Keltainen
	            new Color(0.25f, 0.25f, 0.25f),
	            new Color(0.75f, 0.25f, 0.25f),
	            new Color(0.75f, 0.75f, 0.00f), // Kirkkaampi keltainen
	            new Color(0.25f, 0.25f, 0.75f),
	            new Color(0.58f, 0.58f, 0.58f),
	            new Color(0.00f, 1.00f, 0.00f),
	            new Color(0.76f, 0.57f, 0.17f),
	            new Color(0.54f, 0.63f, 0.22f),
	            new Color(0.80f, 0.52f, 0.85f),
	            new Color(0.10f, 0.49f, 0.47f),
	            new Color(0.66f, 0.34f, 0.65f),
	            new Color(0.99f, 0.41f, 0.23f)
	    };
	    JarisPaintName = new String[] {
	            Messages.JarisPaints_0,
	            Messages.JarisPaints_1,
	            Messages.JarisPaints_2,
	            Messages.JarisPaints_3,
	            Messages.JarisPaints_4,
	            Messages.JarisPaints_5,
	            Messages.JarisPaints_6,
	            Messages.JarisPaints_7,
	            Messages.JarisPaints_8,
	            Messages.JarisPaints_9,
	            Messages.JarisPaints_10,
	            Messages.JarisPaints_11,
	            Messages.JarisPaints_12,
	            Messages.JarisPaints_13,
	            Messages.JarisPaints_14,
	            Messages.JarisPaints_15,
	            Messages.JarisPaints_16,
	            Messages.JarisPaints_17
	    };	
	    
	}

}
