/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.trend.configuration;

import org.simantics.databoard.util.Bean;

/**
 * ViewProfile specifies a view settings of a chart.
 * 
 * ViewProfiles can exist in different scopes: Transient, Model, Workspace
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class ViewProfile extends Bean {

    public String profileName;

    public boolean showMilestones;

    /**
     * Whether to render the value grid in the chart or not.
     */
    public boolean showGrid;

    public TimeWindow timeWindow;

    /**
     * If <code>true</code> the momentary value hairline shall follow current
     * experiment time when simulation is in running state.
     */
    public boolean trackExperimentTime;

    /**
     * Relative position in (0,0)x(1,1) for the momentary value view.
     */
    public double valueViewPositionX = 1;
    public double valueViewPositionY = 0;

    /**
     * Either one color (3 values) or a vertical color gradient (6 values).
     */
    public float[] backgroundColor;

    /**
     * Optional grid color in RGB, 3 float values.
     * By default (0,7451, 0,7451, 0,8627), i.e. (190, 190, 220) or <code>#BEBEDC</code>.
     */
    public float[] gridColor;

}
