/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.ui;

import java.io.IOException;
import org.eclipse.ui.IPersistableElement;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptions;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.TextualModuleSource;
import org.simantics.scl.ui.editor2.StandardSCLModuleEditorInput;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STSTestEditorInput
extends StandardSCLModuleEditorInput {
    private static final Logger LOGGER = LoggerFactory.getLogger(STSTestEditorInput.class);

    public STSTestEditorInput(String moduleName) {
        super(moduleName);
    }

    public boolean exists() {
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(ModuleSource.class)) {
            try {
                return (T)Simantics.getSession().syncRequest((Read)new ReadSTSModuleSource(this.getModuleName()));
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        if (adapter.equals(IPersistableElement.class)) {
            return (T)((Object)this);
        }
        return null;
    }

    public String getFactoryId() {
        return "org.simantics.tests.modelled.ui.stseditor.inputFactory";
    }

    static class ReadSTSModuleSource
    extends UnaryRead<String, ModuleSource> {
        public ReadSTSModuleSource(String moduleName) {
            super((Object)moduleName);
        }

        public ModuleSource perform(ReadGraph graph) throws DatabaseException {
            Resource moduleResource = graph.getPossibleResource((String)this.parameter);
            if (moduleResource == null) {
                return null;
            }
            TestsResource TESTS = TestsResource.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(moduleResource, TESTS.STSTest)) {
                return null;
            }
            String text = (String)graph.getRelatedValue(moduleResource, TESTS.STSTest_definition);
            return new STSTextualModuleSource((String)this.parameter, text);
        }
    }

    private static class STSTextualModuleSource
    extends TextualModuleSource {
        private String moduleText;

        public STSTextualModuleSource(String stsModuleURI, String moduleText) {
            super(stsModuleURI);
            this.moduleText = moduleText;
        }

        public void update(String newSourceText) {
            try {
                Simantics.getSession().syncRequest((Write)new WriteSTSModuleSource(this.getModuleName(), newSourceText));
            }
            catch (DatabaseException e) {
                LOGGER.error("", (Throwable)e);
            }
        }

        public Failable<Module> compileModule(ModuleRepository environment, UpdateListener listener, ModuleCompilationOptions options) {
            return super.compileModule(environment, listener, options);
        }

        public boolean isUpdateable() {
            return true;
        }

        public String getSourceText(UpdateListener listener) throws IOException {
            return this.moduleText;
        }
    }

    static class WriteSTSModuleSource
    extends WriteRequest {
        private final String moduleURI;
        private final String sourceText;

        public WriteSTSModuleSource(String moduleURI, String sourceText) {
            this.moduleURI = moduleURI;
            this.sourceText = sourceText;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            Resource moduleResource = graph.getPossibleResource(this.moduleURI);
            if (moduleResource == null) {
                return;
            }
            TestsResource TESTS = TestsResource.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(moduleResource, TESTS.STSTest)) {
                return;
            }
            graph.claimLiteral(moduleResource, TESTS.STSTest_definition, (Object)this.sourceText);
        }
    }
}

