package org.simantics.modeling.tests.commands;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.modeling.tests.traits.SingleResourceTrait;

public class WriteConfiguration extends WriteCommand<CommandSequenceEnvironment> {

	transient public SingleResourceTrait model;
	transient public String rvi;
	transient public Object value;
	transient public Binding binding;
	
	public WriteConfiguration(SingleResourceTrait model, String rvi, Object value, Binding binding) {
		this.model = model;
		this.rvi = rvi;
		this.value = value;
		this.binding = binding;
	}
	
	@Override
	public void run(CommandSequenceEnvironment environment) throws DatabaseException {
	        		
		Utils.writeConfiguration(model.getResource(), rvi, value, binding);
		
	}

}