package org.simantics.modeling.tests.commands;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collections;

import junit.framework.Assert;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;
import org.simantics.modeling.tests.traits.SingleResourceTrait;
import org.simantics.modeling.tests.traits.SingleResourceTraitImpl;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.structural2.modelingRules.IModelingRules;


public class Connect extends ResourceWriteCommand<ModelingCommandSequenceTest> implements SingleResourceTrait {

	private SingleResourceTrait diagram;
	private SingleResourceTrait m1;
	private SingleResourceTrait m2;
	private SingleResourceTrait c1;
	private SingleResourceTrait c2;
	
	public Connect(SingleResourceTrait diagram, SingleResourceTrait m1, SingleResourceTrait c1, SingleResourceTrait m2, SingleResourceTrait c2) {
		this.diagram = diagram;
		this.m1 = m1;
		this.c1 = c1;
		this.m2 = m2;
		this.c2 = c2;
	}
	
	public Connect(SingleResourceTrait diagram, SingleResourceTrait m1, SingleResourceTrait c1, SingleResourceTrait m2, Resource c2) {
		this.diagram = diagram;
		this.m1 = m1;
		this.c1 = c1;
		this.m2 = m2;
		this.c2 = new SingleResourceTraitImpl(c2);
	}

	public Connect(SingleResourceTrait diagram, SingleResourceTrait m1, Resource c1, SingleResourceTrait m2, SingleResourceTrait c2) {
		this.diagram = diagram;
		this.m1 = m1;
		this.c1 = new SingleResourceTraitImpl(c1);
		this.m2 = m2;
		this.c2 = c2;
	}
	
	public Connect(SingleResourceTrait diagram, SingleResourceTrait m1, Resource c1, SingleResourceTrait m2, Resource c2) {
		this.diagram = diagram;
		this.m1 = m1;
		this.c1 = new SingleResourceTraitImpl(c1);
		this.m2 = m2;
		this.c2 = new SingleResourceTraitImpl(c2);
	}

	@Override
	protected Resource run(WriteGraph graph, ModelingCommandSequenceTest environment) throws DatabaseException {
	
		ConnectionUtil cu = new ConnectionUtil(graph);
		Resource conn = cu.createConnectionWithCorners(graph, m1.getResource(graph), c1.getResource(graph), m2.getResource(graph), c2.getResource(graph), Collections.<Point2D>emptyList());
		
		Layer0 L0 = Layer0.getInstance(graph);
		StructuralResource2 STR = StructuralResource2.getInstance(graph);
        graph.claim(conn, L0.PartOf, diagram.getResource());

		AddElement.claimFreshElementName(graph, diagram.getResource(), conn);
        OrderedSetUtils.addFirst(graph, diagram.getResource(), conn);

        IModelingRules modelingRules = graph.syncRequest(DiagramRequests.getModelingRules(diagram.getResource(), null));

        IConnectionPoint cp1 = new CPTerminal(m1.getResource(graph), c1.getResource(graph));
        IConnectionPoint cp2 = new CPTerminal(m2.getResource(graph), c2.getResource(graph));
       
        ConnectionJudgement judgement = modelingRules.judgeConnection(graph, Arrays.asList(cp1, cp2));
        
        Assert.assertNotNull(judgement.connectionType);
        
        graph.claim(conn, STR.HasConnectionType, null, judgement.connectionType);
        
        return conn;
        
	}
	
}