package org.simantics.modeling.tests.commands;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.tests.traits.SingleModelTrait;
import org.simantics.modeling.tests.traits.SingleResourceTrait;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural2.utils.StructuralUtils;

public class AddDiagram extends ResourceWriteCommand<CommandSequenceEnvironment> implements SingleResourceTrait {

	private SingleModelTrait model;
	private Resource compositeType;
	private String name;
	
	public AddDiagram(SingleModelTrait model, Resource compositeType, String name) {
		this.model = model;
		this.compositeType = compositeType;
		this.name = name;
	}
	
	@Override
	protected Resource run(WriteGraph graph, CommandSequenceEnvironment environment) throws DatabaseException {
		
        SimulationResource SIMU = SimulationResource.getInstance(graph);
        
        Resource target = graph.getSingleObject(model.getResource(), SIMU.HasConfiguration);

        Resource composite = StructuralUtils.newComponent(graph, target, name, compositeType);
        
		return graph.getSingleObject(composite, ModelingResources.getInstance(graph).CompositeToDiagram);
		
	}
	
	public String getName() {
		return name;
	}

}