package org.simantics.help;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class HelpResources {
    
    public final Resource Actions;
    public final Resource Actions_NewHelpLibrary;
    public final Resource Actions_NewHelpTutorial;
    public final Resource Contributions;
    public final Resource Contributions_HelpFileImage;
    public final Resource Contributions_HelpFiles;
    public final Resource Contributions_HelpLibraryImage;
    public final Resource Contributions_NewHelpLibrary;
    public final Resource Contributions_NewHelpTutorial;
    public final Resource HelpFile;
    public final Resource HelpFile_contents;
    public final Resource HelpFile_contents_Inverse;
    public final Resource HelpLibrary;
    public final Resource SCLMain;
    public final Resource TutorialFile;
        
    public static class URIs {
        public static final String Actions = "http://www.simantics.org/Help-1.0/Actions";
        public static final String Actions_NewHelpLibrary = "http://www.simantics.org/Help-1.0/Actions/NewHelpLibrary";
        public static final String Actions_NewHelpTutorial = "http://www.simantics.org/Help-1.0/Actions/NewHelpTutorial";
        public static final String Contributions = "http://www.simantics.org/Help-1.0/Contributions";
        public static final String Contributions_HelpFileImage = "http://www.simantics.org/Help-1.0/Contributions/HelpFileImage";
        public static final String Contributions_HelpFiles = "http://www.simantics.org/Help-1.0/Contributions/HelpFiles";
        public static final String Contributions_HelpLibraryImage = "http://www.simantics.org/Help-1.0/Contributions/HelpLibraryImage";
        public static final String Contributions_NewHelpLibrary = "http://www.simantics.org/Help-1.0/Contributions/NewHelpLibrary";
        public static final String Contributions_NewHelpTutorial = "http://www.simantics.org/Help-1.0/Contributions/NewHelpTutorial";
        public static final String HelpFile = "http://www.simantics.org/Help-1.0/HelpFile";
        public static final String HelpFile_contents = "http://www.simantics.org/Help-1.0/HelpFile/contents";
        public static final String HelpFile_contents_Inverse = "http://www.simantics.org/Help-1.0/HelpFile/contents/Inverse";
        public static final String HelpLibrary = "http://www.simantics.org/Help-1.0/HelpLibrary";
        public static final String SCLMain = "http://www.simantics.org/Help-1.0/SCLMain";
        public static final String TutorialFile = "http://www.simantics.org/Help-1.0/TutorialFile";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public HelpResources(ReadGraph graph) {
        Actions = getResourceOrNull(graph, URIs.Actions);
        Actions_NewHelpLibrary = getResourceOrNull(graph, URIs.Actions_NewHelpLibrary);
        Actions_NewHelpTutorial = getResourceOrNull(graph, URIs.Actions_NewHelpTutorial);
        Contributions = getResourceOrNull(graph, URIs.Contributions);
        Contributions_HelpFileImage = getResourceOrNull(graph, URIs.Contributions_HelpFileImage);
        Contributions_HelpFiles = getResourceOrNull(graph, URIs.Contributions_HelpFiles);
        Contributions_HelpLibraryImage = getResourceOrNull(graph, URIs.Contributions_HelpLibraryImage);
        Contributions_NewHelpLibrary = getResourceOrNull(graph, URIs.Contributions_NewHelpLibrary);
        Contributions_NewHelpTutorial = getResourceOrNull(graph, URIs.Contributions_NewHelpTutorial);
        HelpFile = getResourceOrNull(graph, URIs.HelpFile);
        HelpFile_contents = getResourceOrNull(graph, URIs.HelpFile_contents);
        HelpFile_contents_Inverse = getResourceOrNull(graph, URIs.HelpFile_contents_Inverse);
        HelpLibrary = getResourceOrNull(graph, URIs.HelpLibrary);
        SCLMain = getResourceOrNull(graph, URIs.SCLMain);
        TutorialFile = getResourceOrNull(graph, URIs.TutorialFile);
    }
    
    public static HelpResources getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        HelpResources ret = session.peekService(HelpResources.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new HelpResources(qc.getIndependentGraph(graph));
            session.registerService(HelpResources.class, ret);
        }
        return ret;
    }
    
    public static HelpResources getInstance(RequestProcessor session) throws DatabaseException {
        HelpResources ret = session.peekService(HelpResources.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<HelpResources>() {
                public HelpResources perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new HelpResources(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(HelpResources.class, ret);
        }
        return ret;
    }
    
}

