package org.simantics.document.server.request;

import gnu.trove.set.hash.THashSet;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableChildren;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.structural.stubs.StructuralResource2;

public class NodesRequest extends VariableRead<Set<Variable>> {

    public NodesRequest(Variable var) {
        super(var);
	}

	@Override
	public Set<Variable> perform(ReadGraph graph) throws DatabaseException {

		long s = System.nanoTime();
		
		StructuralResource2.getInstance(graph);
		if(variable == null)
			return Collections.emptySet();
		
		Set<Variable> nodes = new THashSet<Variable>();
		Collection<Variable> children = graph.syncRequest(new VariableChildren(variable));
		for(Variable child : children) {
			Set<Variable> childNodes = graph.syncRequest(new NodesRequest2(child));
			nodes.addAll(childNodes);
		}
		
        if(DocumentRequest.PROFILE) {
        	long dura = System.nanoTime()-s;
        	System.err.println("NodesRequest " + System.identityHashCode(this) + " in " + 1e-6*dura + "ms. " + variable.getURI(graph));
        }
		
		return nodes;

	}

}