package org.simantics.document.server;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.server.request.DocumentRequest;

public class DocumentValue extends VariableRead<Object> {

	public DocumentValue(Variable variable) {
		super(variable);
	}

	@Override
	public Object perform(ReadGraph graph) throws DatabaseException {
		if(DocumentRequest.PROFILE) return performProfiled(graph);
		return variable.getValue(graph);
	}
	
	public Object performProfiled(ReadGraph graph) throws DatabaseException {
		long start = System.nanoTime();
		Object result = variable.getValue(graph);
		//System.err.println("DocumentValue " + result + " " + variable.getURI(graph));
    	long dura = System.nanoTime()-start;
        if(dura > DocumentRequest.PROFILE_THRESHOLD_VALUEREQUEST * 1e3) {
    		System.err.println("DocumentValue " + System.identityHashCode(this) + " in " + 1e-6*dura + "ms. "+ variable.getURI(graph));
    	}
		return result;
	}
	
	@Override
	public String toString() {
		return "DocumentValue[" + variable + "]";
	}
	
}