/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class IndentingXMLStreamWriter
implements XMLStreamWriter {
    XMLStreamWriter delegate;
    int depth = 0;
    boolean indent = true;

    public IndentingXMLStreamWriter(XMLStreamWriter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.delegate.getProperty(name);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.delegate.setDefaultNamespace(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.delegate.setPrefix(prefix, uri);
    }

    private String getIdent() {
        String s = "\n";
        int i = 0;
        while (i < this.depth) {
            s = String.valueOf(s) + "  ";
            ++i;
        }
        return s;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        if (this.indent) {
            this.delegate.writeCharacters(this.getIdent());
        }
        this.delegate.writeStartElement(localName);
        ++this.depth;
        this.indent = true;
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (this.indent) {
            this.delegate.writeCharacters(this.getIdent());
        }
        this.delegate.writeStartElement(namespaceURI, localName);
        ++this.depth;
        this.indent = true;
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (this.indent) {
            this.delegate.writeCharacters(this.getIdent());
        }
        this.delegate.writeStartElement(prefix, localName, namespaceURI);
        ++this.depth;
        this.indent = true;
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
        ++this.depth;
        this.indent = true;
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.delegate.writeStartDocument(version);
        ++this.depth;
        this.indent = true;
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.delegate.writeStartDocument(encoding, version);
        ++this.depth;
        this.indent = true;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.depth;
        if (this.indent) {
            this.delegate.writeCharacters(this.getIdent());
        }
        this.delegate.writeEndElement();
        this.indent = true;
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        --this.depth;
        if (this.indent) {
            this.delegate.writeCharacters(this.getIdent());
        }
        this.delegate.writeEndDocument();
        this.indent = true;
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.delegate.writeEmptyElement(namespaceURI, localName);
        this.indent = true;
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
        this.indent = true;
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.delegate.writeEmptyElement(localName);
        this.indent = true;
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.delegate.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.delegate.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.delegate.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.delegate.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.delegate.writeEntityRef(name);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.delegate.writeCharacters(text);
        this.indent = false;
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.delegate.writeCharacters(text, start, len);
        this.indent = false;
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.delegate.setNamespaceContext(context);
    }
}

