/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.utils;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class StringColumnComparator
extends ViewerComparator {
    private int propertyIndex = 0;
    private static final int DESCENDING = 1;
    private int direction = 1;

    public void setColumnt(int column) {
        if (column == this.propertyIndex) {
            this.direction = 1 - this.direction;
        } else {
            this.propertyIndex = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        int rc = 0;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            rc = cat1 - cat2;
        } else {
            String name1 = null;
            String name2 = null;
            if (viewer == null || !(viewer instanceof ContentViewer)) {
                name1 = e1.toString();
                name2 = e2.toString();
            } else {
                CellLabelProvider clp;
                IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
                if (viewer instanceof TableViewer && ((TableViewer)viewer).getLabelProvider(this.propertyIndex) != null && (clp = ((TableViewer)viewer).getLabelProvider(this.propertyIndex)) instanceof ILabelProvider) {
                    ILabelProvider ilb = (ILabelProvider)clp;
                    name1 = ilb.getText(e1);
                    name2 = ilb.getText(e2);
                }
                if (name1 == null) {
                    ITableLabelProvider lprov;
                    if (prov instanceof ITableLabelProvider) {
                        lprov = (ITableLabelProvider)prov;
                        name1 = lprov.getColumnText(e1, this.propertyIndex);
                        name2 = lprov.getColumnText(e2, this.propertyIndex);
                    } else if (prov instanceof ILabelProvider) {
                        lprov = (ILabelProvider)prov;
                        name1 = lprov.getText(e1);
                        name2 = lprov.getText(e2);
                    } else {
                        name1 = e1.toString();
                        name2 = e2.toString();
                    }
                }
            }
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            rc = this.getComparator().compare(name1, name2);
        }
        if (this.direction != 1) {
            rc = -rc;
        }
        return rc;
    }
}

