/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.browsing;

import java.util.function.Consumer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.imagers.ContainerImager;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.browsing.ui.graph.impl.MissingImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.browsing.INode;

class NodeImagerFactory
implements ImagerFactory {
    NodeImagerFactory() {
    }

    public Imager create(final PrimitiveQueryUpdater updater, final NodeContext context, final BuiltinKeys.ImagerKey key) {
        final ContainerImager result = new ContainerImager();
        result.setImage((Object)MissingImageDescriptor.getInstance());
        DataSource source = updater.getDataSource(ReadGraph.class);
        source.schedule((Consumer)new Consumer<ReadGraph>(){

            @Override
            public void accept(ReadGraph g) {
                try {
                    INode node = (INode)context.getConstant(BuiltinKeys.INPUT);
                    ImageDescriptor descriptor = node.getImage(g);
                    result.setImage((Object)descriptor);
                    updater.scheduleReplace(context, (NodeContext.PrimitiveQueryKey)key, (Object)result);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
        });
        return result;
    }
}

