/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.update.model.PropertyChange;
import org.simantics.utils.datastructures.Pair;

public class UpdateList {
    private HashSet<PropertyChange> changes;

    public UpdateList() {
        this.changes = new HashSet();
    }

    public UpdateList(Collection<PropertyChange> changes) {
        this.changes = new HashSet<PropertyChange>(changes);
    }

    public UpdateList(GraphChanges graphChanges, Collection<Pair<Statement, Statement>> coll) {
        this.changes = new HashSet();
        for (Pair<Statement, Statement> p : coll) {
            this.changes.add(this.create(graphChanges, p));
        }
    }

    protected PropertyChange create(GraphChanges changes, Pair<Statement, Statement> change) {
        return new PropertyChange(changes, change);
    }

    public Collection<PropertyChange> getChanges() {
        return this.changes;
    }

    public void addChange(PropertyChange change) {
        this.changes.add(change);
    }

    public void removeChange(PropertyChange change) {
        this.changes.remove(change);
    }

    public Collection<PropertyChange> getSelected() {
        HashSet<PropertyChange> selected = new HashSet<PropertyChange>();
        for (PropertyChange c : selected) {
            if (!c.selected()) continue;
            selected.add(c);
        }
        return selected;
    }

    public void clearSelected() {
        for (PropertyChange c : this.changes) {
            c.select(false);
        }
    }

    public PropertyChange getChange(ReadGraph g, Statement s) throws DatabaseException {
        for (PropertyChange c : this.changes) {
            if (s.equals(c.pair.first)) {
                return c;
            }
            if (!s.equals(c.pair.second)) continue;
            return c;
        }
        return null;
    }

    public Collection<PropertyChange> getChanges(ReadGraph g, Resource r) throws DatabaseException {
        ArrayList<PropertyChange> list = new ArrayList<PropertyChange>();
        for (PropertyChange pair : this.changes) {
            if (pair.getFirst() != null) {
                if (pair.getFirst().getSubject().equals(r)) {
                    list.add(pair);
                    continue;
                }
                if (pair.getFirst().getObject().equals(r)) {
                    list.add(pair);
                    continue;
                }
            }
            if (pair.getSecond() == null) continue;
            if (pair.getSecond().getSubject().equals(r)) {
                list.add(pair);
                continue;
            }
            if (!pair.getSecond().getObject().equals(r)) continue;
            list.add(pair);
        }
        return list;
    }
}

