/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.test.GraphChanges;
import org.simantics.utils.datastructures.Pair;

public class PropertyChange {
    protected GraphChanges changes;
    protected Pair<Statement, Statement> pair;
    protected boolean applied = false;
    protected boolean selected = false;
    protected boolean visible = true;

    public PropertyChange(GraphChanges changes, Statement first, Statement second) {
        if (first == null && second == null) {
            throw new IllegalArgumentException("At least one of the stamenents must be non null.");
        }
        this.pair = new Pair((Object)first, (Object)second);
        this.changes = changes;
    }

    public PropertyChange(GraphChanges changes, Pair<Statement, Statement> change) {
        if (change == null || change.first == null && change.second == null) {
            throw new IllegalArgumentException("At least one of the stamenents must be non null.");
        }
        this.pair = change;
        this.changes = changes;
    }

    public Statement getFirst() {
        return (Statement)this.pair.first;
    }

    public Statement getSecond() {
        return (Statement)this.pair.second;
    }

    public GraphChanges getChanges() {
        return this.changes;
    }

    public int hashCode() {
        return this.pair.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PropertyChange c = (PropertyChange)obj;
        return this.pair.equals(c.pair);
    }

    public void apply(WriteGraph graph) throws DatabaseException {
        if (this.applied) {
            return;
        }
        if (this.pair.second == null) {
            graph.deny((Statement)this.pair.first);
            return;
        }
        Resource s = (Resource)this.changes.getComparable().getLeft((Object)((Statement)this.pair.second).getSubject());
        Resource pred = ((Statement)this.pair.second).getPredicate();
        if (graph.hasValue(((Statement)this.pair.second).getObject())) {
            Object value = graph.getValue(((Statement)this.pair.second).getObject());
            graph.claimLiteral(s, pred, value);
        } else {
            graph.deny(s, pred);
        }
        this.applied = true;
    }

    public boolean select(boolean select) {
        if (this.applied) {
            return false;
        }
        this.selected = select;
        return true;
    }

    public boolean selected() {
        return this.selected;
    }

    public boolean applied() {
        return this.applied;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String toString() {
        String s = "PropertyChange";
        if (this.pair.first != null) {
            s = String.valueOf(s) + " (" + ((Statement)this.pair.first).getSubject() + " , " + ((Statement)this.pair.first).getPredicate() + " , " + ((Statement)this.pair.first).getObject() + ")";
        }
        if (this.pair.second != null) {
            s = String.valueOf(s) + " (" + ((Statement)this.pair.second).getSubject() + " , " + ((Statement)this.pair.second).getPredicate() + " , " + ((Statement)this.pair.second).getObject() + ")";
        }
        return s;
    }
}

