/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.test.GraphComparator;
import org.simantics.interop.update.model.PropertyChange;
import org.simantics.interop.update.model.UpdateList;
import org.simantics.interop.update.model.UpdateNode;
import org.simantics.interop.update.model.UpdateOp;
import org.simantics.interop.update.model.UpdateTree;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.utils.datastructures.Pair;

public abstract class ModelUpdate {
    private Resource oldModel;
    private Resource newModel;
    private Resource originalModel;
    private GraphChanges changes;
    private UpdateTree updateTree;
    private UpdateList updateList;
    private GraphChanges changes2;
    private UpdateTree updateTree2;
    private UpdateList updateList2;
    private GraphChanges changes3;
    private UpdateTree updateTree3;
    private UpdateList updateList3;
    private List<ChangeFilter> filters = new ArrayList<ChangeFilter>();
    private List<ChangeFilter> userFilters = new ArrayList<ChangeFilter>();
    boolean init = false;
    private List<WarningListener> warningListeners = new ArrayList<WarningListener>();

    public void setInput(Resource oldModel, Resource newModel) throws DatabaseException {
        this.setInput(oldModel, newModel, null, false);
    }

    public void setInput(Resource oldModel, Resource newModel, Resource originalModel, boolean newDistinct) throws DatabaseException {
        this.oldModel = oldModel;
        this.newModel = newModel;
        this.originalModel = originalModel;
        if (originalModel != null) {
            Pair<GraphComparator, String> result2 = this.getChanges(originalModel, oldModel);
            GraphComparator comparator2 = (GraphComparator)result2.first;
            if (result2.second != null) {
                this.showWarning((String)result2.second);
            }
            comparator2.test(this.getSession());
            this.changes2 = comparator2.getChanges();
            this.changes2 = (GraphChanges)this.getSession().syncRequest(this.createFilterRead(this.changes2, this.filters));
            this.updateTree2 = this.getUpdateTree(this.changes2);
            this.updateList2 = this.getUpdateList(this.changes2);
            Pair<GraphComparator, String> result3 = this.getChanges(originalModel, newModel);
            GraphComparator comparator3 = (GraphComparator)result3.first;
            if (result3.second != null) {
                this.showWarning((String)result3.second);
            }
            comparator3.test(this.getSession());
            this.changes3 = comparator3.getChanges();
            this.changes3 = (GraphChanges)this.getSession().syncRequest(this.createFilterRead(this.changes3, this.filters));
        }
        Pair<GraphComparator, String> result = this.getChanges(oldModel, newModel);
        GraphComparator comparator = (GraphComparator)result.first;
        if (result.second != null) {
            this.showWarning((String)result.second);
        }
        if (originalModel != null) {
            for (Map.Entry origToOld : this.changes2.getComparable().getEntries()) {
                Resource oldR = (Resource)origToOld.getValue();
                Resource newR = (Resource)this.changes3.getComparable().getRight((Object)((Resource)origToOld.getKey()));
                if (newR == null) continue;
                comparator.addComparableResources(oldR, newR);
            }
            for (Statement s : this.changes2.getDeletions()) {
                if (!this.changes3.getComparable().containsLeft((Object)s.getObject())) continue;
                comparator.addNonMatchedRight((Resource)this.changes3.getComparable().getRight((Object)s.getObject()));
            }
            for (Statement s : this.changes3.getDeletions()) {
                if (!this.changes2.getComparable().containsLeft((Object)s.getObject())) continue;
                comparator.addNonMatchedLeft((Resource)this.changes2.getComparable().getRight((Object)s.getObject()));
            }
            if (newDistinct) {
                for (Statement s : this.changes2.getAdditions()) {
                    comparator.addNonMatchedLeft(s.getObject());
                }
                for (Statement s : this.changes3.getAdditions()) {
                    comparator.addNonMatchedRight(s.getObject());
                }
            }
        }
        comparator.test(this.getSession());
        this.changes = comparator.getChanges();
        this.changes = (GraphChanges)this.getSession().syncRequest(this.createFilterRead(this.changes, this.filters));
        this.updateTree = this.getUpdateTree(this.changes);
        this.updateList = this.getUpdateList(this.changes);
        if (this.userFilters.size() != 0) {
            this.refreshUserFilters();
        }
        if (originalModel != null) {
            this.defaultSelections();
        }
        this.init = true;
    }

    public void addFilter(ChangeFilter filter) {
        if (this.init) {
            throw new IllegalStateException("ModelUpdate has been initialized, adjusting filters is no longer possible.");
        }
        this.filters.add(filter);
    }

    public List<ChangeFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public void addUserFilter(ChangeFilter filter) {
        this.userFilters.add(filter);
    }

    public void removeUserFilter(ChangeFilter filter) {
        this.userFilters.remove(filter);
    }

    public void clearUserFilters() {
        this.userFilters.clear();
    }

    public List<ChangeFilter> getUserFilters() {
        return this.userFilters;
    }

    public void refreshUserFilters() throws DatabaseException {
        ArrayDeque<UpdateNode> stack = new ArrayDeque<UpdateNode>();
        stack.push(this.updateTree.getRootNode());
        while (!stack.isEmpty()) {
            UpdateNode n = (UpdateNode)stack.pop();
            n.setVisible(true);
            stack.addAll(n.getChildren());
        }
        for (PropertyChange pc : this.updateList.getChanges()) {
            pc.setVisible(true);
        }
        if (this.userFilters.size() > 0) {
            ArrayList<ChangeFilter> combined = new ArrayList<ChangeFilter>(this.filters);
            combined.addAll(this.userFilters);
            GraphChanges filteredChanges = (GraphChanges)this.getSession().syncRequest(this.createFilterRead(this.changes, combined));
            UpdateTree updateTreeF = this.getUpdateTree(filteredChanges);
            UpdateList updateListF = this.getUpdateList(filteredChanges);
            this.applyVisibleFlags(this.updateTree.getRootNode(), updateTreeF.getRootNode());
            this.applyVisibleFlags(this.updateList.getChanges(), updateListF.getChanges());
        }
    }

    private void applyVisibleFlags(UpdateNode l, UpdateNode r) {
        BijectionMap comparable = new BijectionMap();
        block0: for (UpdateNode lc : l.getChildren()) {
            for (UpdateNode rc : r.getChildren()) {
                if (comparable.containsRight((Object)rc)) continue;
                if (lc.getResource() != null) {
                    if (!lc.getResource().equals(rc.getResource())) continue;
                    comparable.map((Object)lc, (Object)rc);
                    continue block0;
                }
                if (rc.getResource() != null) continue;
                UpdateOp lop = lc.getOp();
                UpdateOp rop = rc.getOp();
                if (lop.getStatement() == null || !lop.getStatement().equals(rop.getStatement())) continue;
                comparable.map((Object)lc, (Object)rc);
                continue block0;
            }
        }
        for (UpdateNode lc : l.getChildren()) {
            if (comparable.containsLeft((Object)lc)) continue;
            lc.setVisible(false);
        }
        for (Map.Entry entry : comparable.getEntries()) {
            this.applyVisibleFlags((UpdateNode)entry.getKey(), (UpdateNode)entry.getValue());
        }
    }

    private void applyVisibleFlags(Collection<PropertyChange> l, Collection<PropertyChange> r) {
        BijectionMap comparable = new BijectionMap();
        block0: for (PropertyChange lc : l) {
            for (PropertyChange rc : r) {
                if (comparable.containsRight((Object)rc)) continue;
                if (lc.getFirst() != null && lc.getFirst().equals(rc.getFirst())) {
                    comparable.map((Object)lc, (Object)rc);
                    continue block0;
                }
                if (lc.getSecond() == null || !lc.getSecond().equals(rc.getSecond())) continue;
                comparable.map((Object)lc, (Object)rc);
                continue block0;
            }
        }
        for (PropertyChange lc : l) {
            if (comparable.containsLeft((Object)lc)) continue;
            lc.setVisible(false);
        }
    }

    protected abstract Pair<GraphComparator, String> getChanges(Resource var1, Resource var2) throws DatabaseException;

    protected abstract UpdateTree getUpdateTree(GraphChanges var1) throws DatabaseException;

    protected UpdateList getUpdateList(GraphChanges changes) throws DatabaseException {
        return new UpdateList(changes, changes.getModifications());
    }

    public Resource getOldModel() {
        return this.oldModel;
    }

    public Resource getNewModel() {
        return this.newModel;
    }

    public Resource getOriginalModel() {
        return this.originalModel;
    }

    public boolean isInit() {
        return this.init;
    }

    public GraphChanges getChanges() {
        return this.changes;
    }

    public UpdateTree getUpdateTree() {
        return this.updateTree;
    }

    public UpdateList getUpdateList() {
        return this.updateList;
    }

    public GraphChanges getChanges2() {
        return this.changes2;
    }

    public UpdateTree getUpdateTree2() {
        return this.updateTree2;
    }

    public UpdateList getUpdateList2() {
        return this.updateList2;
    }

    public GraphChanges getChanges3() {
        return this.changes3;
    }

    public UpdateTree getUpdateTree3() throws DatabaseException {
        if (this.updateTree3 == null && this.changes3 != null) {
            this.updateTree3 = this.getUpdateTree(this.changes3);
        }
        return this.updateTree3;
    }

    public UpdateList getUpdateList3() throws DatabaseException {
        if (this.updateList3 == null && this.changes3 != null) {
            this.updateList3 = this.getUpdateList(this.changes3);
        }
        return this.updateList3;
    }

    public void applyAll(WriteGraph graph) throws DatabaseException {
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)"Apply all model updates");
        graph.markUndoPoint();
        for (PropertyChange mod : this.updateList.getChanges()) {
            mod.apply(graph);
        }
        this.updateTree.getUpdateOps().applyAll(graph);
    }

    public void applySelected(WriteGraph graph) throws DatabaseException {
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)"Apply selected model updates");
        graph.markUndoPoint();
        for (PropertyChange mod : this.updateList.getChanges()) {
            if (!mod.selected()) continue;
            mod.apply(graph);
        }
        this.updateTree.getUpdateOps().applySelected(graph);
    }

    protected Session getSession() {
        return Simantics.getSession();
    }

    public Read<GraphChanges> createFilterRead(GraphChanges changes, List<ChangeFilter> filters) {
        return new FilterChangesRead(changes, filters);
    }

    public void defaultSelections() {
        if (this.changes3 == null) {
            return;
        }
        for (Map.Entry<Resource, UpdateOp> entry : this.updateTree.getUpdateOps().getResourceMap().entrySet()) {
            entry.getValue().select(true);
        }
        for (PropertyChange propertyChange : this.updateList.getChanges()) {
            propertyChange.select(true);
        }
        for (Map.Entry entry : this.updateTree.getUpdateOps().getResourceMap().entrySet()) {
            UpdateOp op2 = this.updateTree2.getUpdateOps().getUpdateOp((Resource)entry.getKey());
            if (op2 == null && this.changes3.getComparable().containsRight((Object)((Resource)entry.getKey()))) {
                op2 = this.updateTree2.getUpdateOps().getUpdateOp((Resource)this.changes3.getComparable().getLeft((Object)((Resource)entry.getKey())));
            }
            if (op2 == null || ((UpdateOp)entry.getValue()).getClass() != op2.getClass()) continue;
            ((UpdateOp)entry.getValue()).select(false);
        }
        for (PropertyChange propertyChange : this.updateList.getChanges()) {
            if (propertyChange.getFirst() == null) continue;
            boolean found = false;
            for (PropertyChange pair2 : this.updateList2.getChanges()) {
                if (propertyChange.getFirst() == null || !propertyChange.getFirst().equals(pair2.getSecond())) continue;
                found = true;
                break;
            }
            if (!found) continue;
            propertyChange.select(false);
        }
    }

    private void showWarning(String string) {
        for (WarningListener l : this.warningListeners) {
            l.showWarning(this, string);
        }
    }

    public void addListener(WarningListener listener) {
        this.warningListeners.add(listener);
    }

    public void removeListener(WarningListener listener) {
        this.warningListeners.remove(listener);
    }

    public static interface ChangeFilter {
        public boolean accept(ReadGraph var1, Pair<Statement, Statement> var2) throws DatabaseException;
    }

    protected class FPValueFilter
    implements ChangeFilter {
        private double percentage = 0.01;

        public FPValueFilter() {
        }

        public FPValueFilter(double percentage) {
            if (percentage < 0.0 || percentage > 1.0) {
                throw new IllegalArgumentException("Percentage must be between 0.0 and 1.0.");
            }
            this.percentage = percentage;
        }

        @Override
        public boolean accept(ReadGraph g, Pair<Statement, Statement> change) throws DatabaseException {
            float d2;
            double d22;
            double d1;
            if (!g.hasValue(((Statement)change.first).getObject()) || !g.hasValue(((Statement)change.second).getObject())) {
                return true;
            }
            Object v1 = g.getValue(((Statement)change.first).getObject());
            Object v2 = g.getValue(((Statement)change.second).getObject());
            return !(v1 instanceof Double && v2 instanceof Double ? Math.abs((d1 = ((Double)v1).doubleValue()) - (d22 = ((Double)v2).doubleValue())) / Math.max(Math.abs(d1), Math.abs(d22)) < this.percentage : v1 instanceof Float && v2 instanceof Float && (double)(Math.abs((d1 = ((Float)v1).floatValue()) - (d2 = ((Float)v2).floatValue())) / Math.max(Math.abs(d1), Math.abs(d2))) < this.percentage);
        }
    }

    public static class FilterChangesRead
    implements Read<GraphChanges> {
        private GraphChanges changes;
        private List<ChangeFilter> filters;

        public FilterChangesRead(GraphChanges changes, List<ChangeFilter> filters) {
            this.changes = changes;
            this.filters = filters;
        }

        public GraphChanges perform(ReadGraph graph) throws DatabaseException {
            return this.filterChanges(graph, this.changes);
        }

        protected GraphChanges filterChanges(ReadGraph g, GraphChanges changes) throws DatabaseException {
            ArrayList<Pair> modifications = new ArrayList<Pair>();
            for (Pair mod : changes.getModifications()) {
                boolean accept = true;
                for (ChangeFilter filter : this.filters) {
                    if (filter.accept(g, (Pair<Statement, Statement>)mod)) continue;
                    accept = false;
                    break;
                }
                if (!accept) continue;
                modifications.add(mod);
            }
            GraphChanges newChanges = new GraphChanges(changes.getResource1(), changes.getResource2(), changes.getDeletions(), changes.getAdditions(), modifications, changes.getComparable());
            return newChanges;
        }
    }

    public static interface WarningListener {
        public void showWarning(ModelUpdate var1, String var2);
    }
}

