/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.excel.poi.parser;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.simantics.excel.poi.parser.DataResolver;

public abstract class CellDataResolverBase<T>
implements DataResolver<T> {
    protected Double getCellNumericValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellTypeEnum()) {
            case BLANK: {
                return null;
            }
            case BOOLEAN: {
                return null;
            }
            case ERROR: {
                return null;
            }
            case FORMULA: {
                return null;
            }
            case NUMERIC: {
                return cell.getNumericCellValue();
            }
            case STRING: {
                return null;
            }
            case _NONE: {
                return null;
            }
        }
        throw new RuntimeException();
    }

    protected String getCellStringValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellTypeEnum()) {
            case BLANK: {
                return null;
            }
            case BOOLEAN: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case ERROR: {
                return null;
            }
            case FORMULA: {
                return null;
            }
            case NUMERIC: {
                return Double.toString(cell.getNumericCellValue());
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case _NONE: {
                return null;
            }
        }
        throw new RuntimeException();
    }

    protected Boolean getCellBooleanValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellTypeEnum()) {
            case BLANK: {
                return null;
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case ERROR: {
                return null;
            }
            case FORMULA: {
                return null;
            }
            case NUMERIC: {
                return null;
            }
            case STRING: {
                String value = cell.getStringCellValue();
                if ("true".equalsIgnoreCase(value)) {
                    return true;
                }
                if ("1".equalsIgnoreCase(value)) {
                    return true;
                }
                return false;
            }
            case _NONE: {
                return null;
            }
        }
        throw new RuntimeException();
    }

    protected Cell getCell(Row row, int colIndex) {
        short i = row.getFirstCellNum();
        while (i <= row.getLastCellNum()) {
            Cell c = row.getCell((int)i);
            if (c != null && c.getColumnIndex() == colIndex) {
                return c;
            }
            i = (short)(i + 1);
        }
        return null;
    }
}

