/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.ui.handlers;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.district.network.ui.DistrictNetworkUIUtil;
import org.simantics.district.route.Route;
import org.simantics.district.route.RouteJob;
import org.simantics.district.route.RouterConfiguration;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectRouteOnDiagram {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectRouteOnDiagram.class);

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection selection) {
        return ISelectionUtils.filterSingleSelection((Object)selection, Route.class) != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell activeShell, @Named(value="e4ActivePart") MPart part, @Named(value="org.eclipse.ui.selection") ISelection selection) {
        Route route = (Route)ISelectionUtils.filterSingleSelection((Object)selection, Route.class);
        if (route == null) {
            return;
        }
        Display display = activeShell.getDisplay();
        CompletableFuture result = new CompletableFuture();
        ((CompletableFuture)result.exceptionally(e -> Collections.emptyList())).thenAccept(dnElements -> {
            if (!dnElements.isEmpty()) {
                try {
                    SelectRouteOnDiagram.openDiagram(display, dnElements);
                }
                catch (DatabaseException databaseException) {
                    LOGGER.error("Failed to open district network diagram with selection {}", dnElements);
                }
            }
        });
        RouterConfiguration config = new RouterConfiguration();
        new RouteJob(config, route, result).schedule();
    }

    public static boolean openDiagram(Display display, List<Resource> dnElements) throws DatabaseException {
        if (dnElements.isEmpty()) {
            return false;
        }
        DistrictNetworkUIUtil.Input in = (DistrictNetworkUIUtil.Input)Simantics.getSession().syncRequest((Read)new DistrictNetworkUIUtil.ElementToInput(dnElements.get(0)));
        if (in == null) {
            return false;
        }
        SWTUtils.asyncExec((Display)display, () -> DistrictNetworkUIUtil.openDNDiagramEditorWithSelection((DistrictNetworkUIUtil.Input)in, (Object[])dnElements.toArray()));
        return true;
    }
}

