/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.ui;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Composite;
import org.simantics.district.route.ui.RouteTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteView {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteView.class);
    private static final String POPUP_CONTRIBUTION_ID = "org.simantics.district.route.ui.contextMenu";
    public static final String POPUP_ELEMENT_ID = "org.simantics.district.route.ui.popup";
    @Inject
    ESelectionService selectionService;
    @Inject
    IEventBroker broker;
    RouteTree ui;

    @Inject
    public void init(MPart part, MApplication app) {
        MPopupMenu popupMenu = MMenuFactory.INSTANCE.createPopupMenu();
        popupMenu.setElementId(POPUP_ELEMENT_ID);
        List menuContributions = app.getMenuContributions();
        for (MMenuContribution menuContribution : menuContributions) {
            if (!POPUP_CONTRIBUTION_ID.equals(menuContribution.getParentId())) continue;
            popupMenu.getChildren().addAll(menuContribution.getChildren());
        }
        part.getMenus().add(popupMenu);
    }

    @PostConstruct
    public void postConstruct(Composite parent, EMenuService menuService) {
        this.ui = new RouteTree(parent, 0, this.selectionService);
        if (!menuService.registerContextMenu((Object)this.ui.getTree(), POPUP_ELEMENT_ID)) {
            LOGGER.warn("Could not register context menu {}", (Object)POPUP_ELEMENT_ID);
        }
    }

    @PreDestroy
    public void dispose() {
        this.ui = null;
    }

    @Focus
    public void onFocus() {
        this.ui.setFocus();
    }

    public void editCurrentSelection() {
        this.ui.editCurrentSelection();
    }
}

