/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.ui;

import java.util.List;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.simantics.district.route.Route;
import org.simantics.district.route.RouteService;
import org.simantics.district.route.RouteServiceListener;
import org.simantics.district.route.Waypoint;
import org.simantics.district.route.ui.internal.Activator;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteTree
extends Composite {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteTree.class);
    ESelectionService selectionService;
    private LocalResourceManager resourceManager;
    private TreeViewer tree;
    private RouteServiceListener routeServiceListener = e -> {
        LOGGER.info("Route event: {}", (Object)e);
        switch (e.type) {
            case 6: {
                this.runUi(() -> this.tree.refresh());
                break;
            }
            case 4: {
                this.runUi(() -> {
                    this.tree.refresh();
                    this.tree.setExpandedState(routeEvent.obj, true);
                });
                break;
            }
            case 8: {
                this.runUi(() -> {
                    this.tree.refresh(routeEvent.obj);
                    this.tree.setExpandedState(routeEvent.obj, true);
                });
                break;
            }
            case 7: {
                this.runUi(() -> this.tree.refresh(routeEvent.obj));
                break;
            }
            case 11: {
                this.runUi(() -> {
                    this.tree.getTree().setRedraw(false);
                    try {
                        Object[] expanded = this.tree.getExpandedElements();
                        this.tree.setInput((Object)routeEvent.service.listRoutes());
                        this.tree.setExpandedElements(expanded);
                    }
                    finally {
                        this.tree.getTree().setRedraw(true);
                    }
                });
            }
        }
    };

    public RouteTree(Composite parent, int style, ESelectionService selectionService) {
        super(parent, style);
        this.selectionService = selectionService;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.defaultInitializeUI();
        this.trackRouteInput();
    }

    private void trackRouteInput() {
        RouteService rs = Activator.getDefault().getRouteService();
        if (rs != null) {
            rs.addListener(this.routeServiceListener);
            this.addDisposeListener(e -> rs.removeListener(this.routeServiceListener));
            this.setInput(rs.listRoutes());
        }
    }

    private void defaultInitializeUI() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
        this.createTree(this);
    }

    private void createTree(Composite parent) {
        TreeColumnLayout columnLayout = new TreeColumnLayout(false);
        parent.setLayout((Layout)columnLayout);
        this.tree = new TreeViewer(parent, 65540);
        this.tree.setUseHashlookup(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.tree.getControl());
        this.tree.setContentProvider((IContentProvider)new ContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tree.addSelectionChangedListener(this::treeSelectionChanged);
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager(this.tree, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.tree));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tree){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                boolean singleSelect;
                boolean bl = singleSelect = RouteTree.this.tree.getStructuredSelection().size() == 1;
                return singleSelect && (event.eventType == 1 && event.keyCode == 0x100000B || event.eventType == 4);
            }
        };
        int feature = 32;
        TreeViewerEditor.create((TreeViewer)this.tree, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)feature);
        final TextCellEditor textCellEditor = new TextCellEditor((Composite)this.tree.getTree());
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.tree, 16384);
        columnLayout.setColumnData((Widget)viewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider());
        viewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tree){

            protected void setValue(Object element, Object value) {
                LOGGER.info("set value {} for {}", value, element);
                Route r = (Route)element;
                r.setName((String)value);
                Activator.getDefault().getRouteService().persistRoute(r);
                this.getViewer().update(element, null);
            }

            protected Object getValue(Object element) {
                return ((Route)element).getName();
            }

            protected CellEditor getCellEditor(Object element) {
                return textCellEditor;
            }

            protected boolean canEdit(Object element) {
                return element instanceof Route;
            }
        });
    }

    private void treeSelectionChanged(SelectionChangedEvent e) {
        this.selectionService.setSelection((Object)e.getSelection());
    }

    protected void setInput(List<Route> result) {
        this.runUi(() -> {
            TreePath[] paths = this.tree.getExpandedTreePaths();
            this.tree.setInput((Object)result);
            this.tree.setExpandedTreePaths(paths);
        });
    }

    protected void runUi(Runnable r) {
        SWTUtils.asyncExec((Display)this.getDisplay(), () -> {
            if (!this.tree.getControl().isDisposed()) {
                r.run();
            }
        });
    }

    public Tree getTree() {
        return this.tree.getTree();
    }

    public void editCurrentSelection() {
        ITreeSelection s = this.tree.getStructuredSelection();
        if (s.size() == 1) {
            this.tree.editElement(s.getFirstElement(), 0);
        }
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private static final Object[] NONE = new Object[0];
        private List<?> input;

        private ContentProvider() {
        }

        public void dispose() {
            this.input = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput instanceof List ? (List)newInput : null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return NONE;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Route) {
                return ((Route)parentElement).waypoints().toArray();
            }
            return NONE;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Route) {
                return !((Route)element).waypoints().isEmpty();
            }
            return false;
        }
    }

    private static class LabelProvider
    extends ColumnLabelProvider {
        private LabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Route) {
                Route r = (Route)element;
                return NLS.bind((String)"{0} ({1} waypoints)", (Object)r.getName(), (Object)r.count());
            }
            boolean cfr_ignored_0 = element instanceof Waypoint;
            return element.toString();
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            cell.setText(this.getText(element));
        }
    }
}

