/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.district.network.ModelledCRS;
import org.simantics.district.network.ui.DNEdgeBuilder;
import org.simantics.district.network.ui.NetworkDrawingParticipant;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.IToolMode;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class NetworkDrawingNode
extends G2DNode {
    private static final long serialVersionUID = -3475301184009620573L;
    private Point2D currentMousePos = null;
    private List<Point2D> nodes = new ArrayList<Point2D>();
    private Resource diagramResource;
    private boolean committed;
    private NetworkDrawingParticipant participant;
    private IDiagram diagram;
    private static final Stroke DASHED_STROKE = new BasicStroke(2.0f, 1, 1, 4.0f, new float[]{4.0f}, 0.0f);
    private static final Color BLUE_ALPHA = new Color(0, 0, 255, 100);
    private boolean scaleStroke = true;

    public void init() {
        super.init();
        this.addEventHandler((IEventHandler)this);
    }

    public void setNetworkDrawingParticipant(NetworkDrawingParticipant participant) {
        this.participant = participant;
    }

    public void setDiagram(IDiagram diagram) {
        if (diagram != null) {
            this.diagram = diagram;
            this.diagramResource = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        }
    }

    public void render(Graphics2D g2d) {
        Point2D node;
        if (this.nodes.isEmpty()) {
            return;
        }
        Path2D.Double path = new Path2D.Double();
        Iterator<Point2D> nodeIter = this.nodes.iterator();
        if (nodeIter.hasNext()) {
            node = nodeIter.next();
            ((Path2D)path).moveTo(node.getX(), node.getY());
        }
        while (nodeIter.hasNext()) {
            node = nodeIter.next();
            ((Path2D)path).lineTo(node.getX(), node.getY());
        }
        if (this.currentMousePos != null) {
            ((Path2D)path).lineTo(this.currentMousePos.getX(), this.currentMousePos.getY());
        }
        Color old = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        if (DASHED_STROKE != null) {
            if (this.scaleStroke && DASHED_STROKE instanceof BasicStroke) {
                BasicStroke bs = GeometryUtils.scaleStroke((Stroke)DASHED_STROKE, (float)((float)(1.0 / GeometryUtils.getScale((AffineTransform)g2d.getTransform()))));
                g2d.setStroke(bs);
            } else {
                g2d.setStroke(DASHED_STROKE);
            }
        }
        g2d.setColor(BLUE_ALPHA);
        g2d.draw(path);
        g2d.setStroke(oldStroke);
        g2d.setColor(old);
    }

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    public int getEventMask() {
        return EventTypes.AnyMask;
    }

    protected boolean mouseDoubleClicked(MouseEvent.MouseDoubleClickedEvent e) {
        IToolMode mode = this.getToolMode();
        if (mode == Hints.CONNECTTOOL || e.hasAnyModifier(8704)) {
            Point2D start = null;
            Point2D end = null;
            Iterator<Point2D> nodeIter = this.nodes.iterator();
            while (nodeIter.hasNext()) {
                if (end == null) {
                    start = nodeIter.next();
                    if (!nodeIter.hasNext()) {
                        break;
                    }
                } else {
                    start = end;
                }
                end = nodeIter.next();
                this.createEdge(start, end);
            }
            this.nodes.clear();
            this.committed = true;
            this.repaint();
            return true;
        }
        return super.mouseDoubleClicked(e);
    }

    private void createEdge(Point2D start, Point2D end) {
        final double padding = GeometryUtils.getScale((AffineTransform)this.getTransform());
        double scaleY = this.getTransform().getScaleY();
        double scaleX = this.getTransform().getScaleX();
        double startLat = ModelledCRS.yToLatitude((double)(-start.getY() / scaleY));
        double startLon = ModelledCRS.xToLongitude((double)(start.getX() / scaleX));
        double endLat = ModelledCRS.yToLatitude((double)(-end.getY() / scaleY));
        double endLon = ModelledCRS.xToLongitude((double)(end.getX() / scaleX));
        final double[] startCoords = new double[]{startLon, startLat};
        final double[] endCoords = new double[]{endLon, endLat};
        final DNEdgeBuilder builder = new DNEdgeBuilder(this.diagramResource, this.diagram);
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                builder.create(graph, startCoords, endCoords, 1.0 / padding);
            }
        });
    }

    protected boolean mouseClicked(MouseEvent.MouseClickEvent e) {
        IToolMode mode = this.getToolMode();
        if (mode == Hints.CONNECTTOOL || e.hasAnyModifier(8704)) {
            if (this.committed) {
                this.committed = false;
                return false;
            }
            if (e.button == 2 && !this.nodes.isEmpty()) {
                this.nodes.remove(this.nodes.size() - 1);
            } else if (e.button == 1) {
                Point2D localPos = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)e.controlPosition, (Point2D)new Point2D.Double());
                this.nodes.add(new Point2D.Double(localPos.getX(), localPos.getY()));
            }
            this.repaint();
            return true;
        }
        return super.mouseClicked(e);
    }

    private IToolMode getToolMode() {
        return (IToolMode)this.participant.getHint(Hints.KEY_TOOL);
    }

    protected boolean mouseMoved(MouseEvent.MouseMovedEvent e) {
        IToolMode mode = this.getToolMode();
        if (mode == Hints.CONNECTTOOL || e.hasAnyModifier(8704)) {
            boolean repaint = false;
            Point2D p = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)e.controlPosition, (Point2D)new Point2D.Double());
            if (this.participant.pickHoveredElement(p)) {
                repaint = true;
            }
            if (!this.nodes.isEmpty()) {
                this.currentMousePos = p;
                this.repaint();
                return true;
            }
            this.currentMousePos = null;
            if (repaint) {
                this.repaint();
            }
        }
        return super.mouseMoved(e);
    }

    protected boolean keyPressed(KeyEvent.KeyPressedEvent e) {
        if (e.keyCode == 27) {
            this.nodes.clear();
            this.repaint();
            return true;
        }
        return super.keyPressed(e);
    }
}

