/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.district.network.ModelledCRS;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertex;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ISelectionPainterNode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class DistrictNetworkVertexNode
extends G2DNode
implements ISelectionPainterNode {
    private static final long serialVersionUID = -2641639101400236719L;
    private static final BasicStroke STROKE = new BasicStroke(4.0f, 1, 1);
    private static final Color SELECTION_COLOR = new Color(255, 0, 255, 96);
    private static final double left = -0.25;
    private static final double top = -0.25;
    private static final double width = 0.5;
    private static final double height = 0.5;
    private static final Rectangle2D NORMAL = new Rectangle2D.Double(-0.25, -0.25, 0.5, 0.5);
    private static final Rectangle2D HOVERED = new Rectangle2D.Double(-0.75, -0.75, 1.5, 1.5);
    private DistrictNetworkVertex vertex;
    private boolean scaleStroke = true;
    private boolean hover;
    private Color color;
    private transient Color dynamicColor;
    private Rectangle2D bounds;
    private transient Point2D point;
    private transient Rectangle2D rect;
    private double nodeSize = 1.0;

    public void init() {
        this.setZIndex(2);
    }

    public void render(Graphics2D g2d) {
        if (this.nodeSize <= 0.0) {
            return;
        }
        AffineTransform ot = null;
        AffineTransform t = this.getTransform();
        if (t != null && !t.isIdentity()) {
            ot = g2d.getTransform();
            g2d.transform(this.getTransform());
        }
        Object oaaHint = null;
        Object aaHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (aaHint != RenderingHints.VALUE_ANTIALIAS_OFF) {
            oaaHint = aaHint;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Color oldColor = g2d.getColor();
        Color newColor = this.dynamicColor != null ? this.dynamicColor : this.color;
        boolean changeColor = !oldColor.equals(newColor);
        double viewScaleRecip = 1.0;
        if (this.scaleStroke) {
            double scale = GeometryUtils.getScale((AffineTransform)g2d.getTransform());
            scale = Math.max(10000.0, Math.min(scale, 50000.0));
            viewScaleRecip = 1.0 / scale;
        }
        double scaleRecip = viewScaleRecip * this.nodeSize;
        Point2D p = this.point = DistrictNetworkVertexNode.calculatePoint2D(this.vertex, this.point);
        Rectangle2D toDraw = this.calculateDrawnGeometry(p, this.hover ? HOVERED : NORMAL, this.rect, scaleRecip);
        if (NodeUtil.isSelected((INode)this, (int)1)) {
            changeColor = true;
            g2d.setColor(SELECTION_COLOR);
            BasicStroke ss = GeometryUtils.scaleStroke((Stroke)STROKE, (float)((float)viewScaleRecip * 5.0f));
            g2d.setStroke(ss);
            g2d.draw(toDraw);
        }
        if (changeColor) {
            g2d.setColor(newColor);
        }
        g2d.fill(toDraw);
        if (changeColor) {
            g2d.setColor(oldColor);
        }
        if (oaaHint != null) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
        }
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    private Rectangle2D calculateDrawnGeometry(Point2D p, Rectangle2D margin, Rectangle2D result, double scaleRecip) {
        if (result == null) {
            result = new Rectangle2D.Double();
        }
        double mw = margin.getWidth();
        double mh = margin.getHeight();
        result.setFrame(p.getX() - mw / 2.0 * scaleRecip, p.getY() - mh / 2.0 * scaleRecip, mw * scaleRecip, mh * scaleRecip);
        return result;
    }

    public Rectangle2D getBounds() {
        return super.getBounds();
    }

    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    private void updateBounds() {
        Rectangle2D oldBounds = this.bounds;
        if (oldBounds == null) {
            oldBounds = new Rectangle2D.Double();
        }
        this.bounds = this.calculateBounds(oldBounds);
    }

    public void setTransform(AffineTransform transform) {
        super.setTransform(transform);
        this.updateBounds();
    }

    public AffineTransform getTransform() {
        return super.getTransform();
    }

    private Rectangle2D calculateBounds(Rectangle2D rect) {
        Point2D calcPoint = DistrictNetworkVertexNode.calculatePoint2D(this.vertex, this.point);
        AffineTransform at = this.getTransform();
        return new Rectangle2D.Double(calcPoint.getX(), calcPoint.getY(), 0.5 / at.getScaleX(), 0.5 / at.getScaleY()).getBounds2D();
    }

    private static Point2D calculatePoint2D(DistrictNetworkVertex vertex, Point2D result) {
        Point2D point = vertex.getPoint();
        double x = ModelledCRS.longitudeToX((double)point.getX());
        double y = ModelledCRS.latitudeToY((double)(-point.getY()));
        if (result == null) {
            result = new Point2D.Double(x, y);
        } else {
            result.setLocation(x, y);
        }
        return result;
    }

    public void setVertex(DistrictNetworkVertex vertex) {
        this.vertex = vertex;
        this.updateBounds();
    }

    public boolean hover(boolean hover) {
        boolean changed = false;
        if (this.hover != hover) {
            this.hover = hover;
            changed = true;
        }
        return changed;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    @INode.PropertySetter(value="size")
    public void setSize(Double size) {
        boolean changed = false;
        if (size != null) {
            changed = size != this.nodeSize;
            this.nodeSize = size;
        } else {
            changed = this.nodeSize != 1.0;
            this.nodeSize = 1.0;
        }
        if (changed) {
            this.updateBounds();
        }
    }

    @INode.PropertySetter(value="dynamicColor")
    public void setDynamicColor(Color color) {
        this.dynamicColor = color;
    }
}

