/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.progress.UIJob;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.function.Functions;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeMappingTypeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeMappingTypeHandler.class);

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection selection) {
        final List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (elements.size() < 1) {
            return false;
        }
        try {
            return (Boolean)Simantics.getSession().syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                    for (Resource selection : elements) {
                        if (graph.isInstanceOf(selection, DN.Element)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not evaluate if mapping can be changed for selection {}", (Object)elements, (Object)e);
            return false;
        }
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Object selection) {
        final List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        final CompletableFuture result = new CompletableFuture();
        Simantics.getSession().asyncRequest((Read)new UniqueRead<Map<NamedResource, Collection<NamedResource>>>(){

            public Map<NamedResource, Collection<NamedResource>> perform(ReadGraph graph) throws DatabaseException {
                DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                HashMap<NamedResource, Collection<NamedResource>> currents = new HashMap<NamedResource, Collection<NamedResource>>();
                for (Resource element : elements) {
                    Resource currentMapping = graph.getPossibleObject(element, DN.HasMapping);
                    NamedResource mapping = new NamedResource(NameUtils.getSafeName((ReadGraph)graph, (Resource)currentMapping), currentMapping);
                    currents.compute(mapping, (t, u) -> {
                        if (u == null) {
                            u = new HashSet<NamedResource>();
                        }
                        try {
                            u.add(new NamedResource(NameUtils.getSafeName((ReadGraph)graph, (Resource)element), element));
                        }
                        catch (ServiceException | ValidationException e) {
                            LOGGER.error("Could not compute name for {}", (Object)element, (Object)e);
                        }
                        return u;
                    });
                }
                return currents;
            }
        }, (Procedure)new Procedure<Map<NamedResource, Collection<NamedResource>>>(){

            public void execute(Map<NamedResource, Collection<NamedResource>> results) {
                result.complete(results);
            }

            public void exception(Throwable t) {
                LOGGER.error("Could not compute mappings for selection {}", (Object)elements, (Object)t);
                result.completeExceptionally(t);
            }
        });
        UIJob uiJob = new UIJob("Change mappings.."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SelectMappingDialog dialog = new SelectMappingDialog(this.getDisplay().getActiveShell(), result);
                if (dialog.open() != 0) {
                    return Status.OK_STATUS;
                }
                final Map<Resource, Collection<NamedResource>> results = dialog.getResults();
                DatabaseJob job = new DatabaseJob("Join selected vertices"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                                public void perform(WriteGraph graph) throws DatabaseException {
                                    DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                                    for (Map.Entry entry : results.entrySet()) {
                                        Resource newMapping = (Resource)entry.getKey();
                                        Collection elements = (Collection)entry.getValue();
                                        for (NamedResource element : elements) {
                                            graph.deny(element.getResource(), DN.HasMapping);
                                            graph.claim(element.getResource(), DN.HasMapping, newMapping);
                                        }
                                    }
                                }
                            });
                        }
                        catch (DatabaseException e) {
                            return new Status(4, "org.simantics.district.network.ui", String.valueOf(this.getName()) + " failed.", (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
                return Status.OK_STATUS;
            }
        };
        uiJob.setUser(true);
        uiJob.schedule();
    }

    private static class SelectMappingDialog
    extends SelectionStatusDialog {
        private Map<NamedResource, Combo> mappingCombos = new HashMap<NamedResource, Combo>();
        private Composite composite;
        private CompletableFuture<Map<NamedResource, Collection<NamedResource>>> elements;
        private Map<NamedResource, Map<String, Resource>> possibleMappings = new HashMap<NamedResource, Map<String, Resource>>();
        private Resource defaultVertexMapping;
        private Map<Resource, Collection<NamedResource>> results = new HashMap<Resource, Collection<NamedResource>>();

        protected SelectMappingDialog(Shell parentShell, CompletableFuture<Map<NamedResource, Collection<NamedResource>>> elements) {
            super(parentShell);
            this.elements = elements;
            this.setTitle("Change mappings");
        }

        public Resource getDefaultVertexMapping() {
            return this.defaultVertexMapping;
        }

        protected Control createDialogArea(Composite parent) {
            this.composite = (Composite)super.createDialogArea(parent);
            this.createMappingsGroup(this.composite);
            Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                    try {
                        for (Map.Entry entry : ((Map)elements.get()).entrySet()) {
                            NamedResource currentMapping = (NamedResource)entry.getKey();
                            Resource resource = ((NamedResource)((Collection)entry.getValue()).iterator().next()).getResource();
                            Resource indexRoot = (Resource)graph.sync((ReadInterface)new IndexRoot(resource));
                            if (graph.isInstanceOf(currentMapping.getResource(), DN.Mapping_VertexMapping)) {
                                possibleMappings.put(currentMapping, Functions.getVertexMappings(graph, indexRoot));
                                continue;
                            }
                            if (!graph.isInstanceOf(currentMapping.getResource(), DN.Mapping_EdgeMapping)) continue;
                            possibleMappings.put(currentMapping, Functions.getEdgeMappings(graph, indexRoot));
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                    composite.getDisplay().asyncExec(() -> {
                        for (Map.Entry entry : possibleMappings.entrySet()) {
                            NamedResource key = (NamedResource)entry.getKey();
                            Map value = (Map)entry.getValue();
                            Combo combo = (Combo)mappingCombos.get(key);
                            combo.setItems(value.keySet().toArray(new String[value.size()]));
                            combo.select(0);
                        }
                    });
                }
            });
            return this.composite;
        }

        protected void computeResult() {
            Map<NamedResource, Collection<NamedResource>> currentElements = null;
            try {
                currentElements = this.elements.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Could not get currentElements", (Throwable)e);
                throw new RuntimeException("Could not get currentElements", e);
            }
            for (Map.Entry<NamedResource, Combo> combos : this.mappingCombos.entrySet()) {
                NamedResource resource = combos.getKey();
                Combo c = combos.getValue();
                String item = c.getItem(c.getSelectionIndex());
                Collection<NamedResource> collection = currentElements.get(resource);
                Map<String, Resource> map = this.possibleMappings.get(resource);
                Resource newMapping = map.get(item);
                this.results.compute(newMapping, (t, u) -> {
                    if (u == null) {
                        u = new HashSet();
                    }
                    u.addAll(collection);
                    return u;
                });
            }
        }

        public Map<Resource, Collection<NamedResource>> getResults() {
            return this.results;
        }

        private void createMappingsGroup(Composite parent) {
            try {
                for (Map.Entry<NamedResource, Collection<NamedResource>> entry : this.elements.get().entrySet()) {
                    NamedResource currentMapping = entry.getKey();
                    Collection<NamedResource> mappedElements = entry.getValue();
                    Group group = new Group(parent, 0);
                    group.setFont(parent.getFont());
                    group.setText(String.valueOf(currentMapping.getName()) + " currently mapped to " + mappedElements.size() + " elements");
                    GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
                    group.setLayout((Layout)new GridLayout(1, false));
                    Composite cmposite = new Composite((Composite)group, 0);
                    cmposite.setLayoutData((Object)new GridData(4, 128, true, false));
                    cmposite.setLayout((Layout)new GridLayout(2, false));
                    Label vertexMappingLabel = new Label(cmposite, 0);
                    vertexMappingLabel.setText("New mapping type");
                    Combo c = new Combo(cmposite, 2056);
                    GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)c);
                    this.mappingCombos.put(entry.getKey(), c);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

