/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import java.awt.Color;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ui.DistrictPanZoomRotateHandler;
import org.simantics.district.network.ui.NetworkDrawingParticipant;
import org.simantics.district.network.ui.participants.DNPointerInteractor;
import org.simantics.district.network.ui.participants.MapRulerPainter;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.DelayedBatchElementPainter;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.g2d.participant.RenderingQualityInteractor;
import org.simantics.g2d.participant.ZoomToAreaHandler;
import org.simantics.maps.MapScalingTransform;
import org.simantics.maps.eclipse.MapPainter;
import org.simantics.maps.sg.commands.MapCommands;
import org.simantics.modeling.ui.diagramEditor.DiagramViewer;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictDiagramViewer
extends DiagramViewer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictDiagramViewer.class);

    protected void addDiagramParticipants(ICanvasContext ctx) {
        ctx.add((Object)new ZOrderHandler());
        ctx.add((Object)new Selection());
        ctx.add((Object)new ElementPainter());
        ctx.add((Object)new DNPointerInteractor());
        ctx.add((Object)new MapPainter(MapScalingTransform.INSTANCE));
        ctx.add((Object)new NetworkDrawingParticipant(MapScalingTransform.INSTANCE));
    }

    protected String getPopupId() {
        return "#DistrictDiagramPopup";
    }

    public void initializeCanvasContext(CanvasContext ctx) {
        super.initializeCanvasContext(ctx);
        IHintContext h = ctx.getDefaultHintContext();
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_IN_LIMIT, (Object)10000.0);
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_OUT_LIMIT, (Object)0.01);
        h.setHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE, (Object)this.diagramResource);
    }

    protected void addPainterParticipants(ICanvasContext ctx) {
        ctx.add((Object)new RenderingQualityInteractor());
        ctx.add((Object)new DelayedBatchElementPainter(PickRequest.PickFilter.FILTER_MONITORS, 500L, TimeUnit.MILLISECONDS));
    }

    protected void addGridRulerBackgroundParticipants(CanvasContext ctx) {
        ctx.add((Object)new GridPainter());
        ctx.add((Object)new MapRulerPainter());
        ctx.add((Object)new BackgroundPainter());
    }

    protected void addViewManipulationParticipants(CanvasContext ctx) {
        ctx.add((Object)new DistrictPanZoomRotateHandler());
        ctx.add((Object)new ZoomToAreaHandler());
    }

    protected void loadPageSettings(ICanvasContext ctx) {
        super.loadPageSettings(ctx);
        this.setupDrawMapEnabled();
        this.setupBackgroundColor();
    }

    private void setupDrawMapEnabled() {
        this.sessionContext.getSession().asyncRequest((Read)new DrawMapEnabledRequest(this.getInputResource()), (Listener)new DrawMapEnabledListener(result -> this.canvasContext.getEventQueue().queueEvent((Event)new CommandEvent((Object)this.canvasContext, System.currentTimeMillis(), result != false ? Commands.MAP_ENABLE : Commands.MAP_DISABLE)), () -> this.isDisposed()));
    }

    private void setupBackgroundColor() {
        this.sessionContext.getSession().asyncRequest((Read)new MapBackgroundColorRequest(this.getInputResource()), (Listener)new MapBackgroundColorListener(result -> this.queueBackgroundColorChangeEvent((RGB.Integer)result), () -> this.isDisposed()));
    }

    private void queueBackgroundColorChangeEvent(RGB.Integer result) {
        if (result != null) {
            Color backgroundColor = new Color(result.red, result.green, result.blue);
            this.canvasContext.getDefaultHintContext().setHint(MapCommands.KEY_MAP_BACKGROUND_COLOR, (Object)backgroundColor);
            this.canvasContext.getEventQueue().queueEvent((Event)new CommandEvent((Object)this.canvasContext, System.currentTimeMillis(), MapCommands.MAP_BACKGROUND_COLOR_CHANGE));
        }
    }

    private static class DrawMapEnabledListener
    implements Listener<Boolean> {
        private static final Logger LOGGER = LoggerFactory.getLogger(DrawMapEnabledListener.class);
        private Consumer<Boolean> callback;
        private Supplier<Boolean> isDisposed;

        public DrawMapEnabledListener(Consumer<Boolean> callback, Supplier<Boolean> isDisposed) {
            this.callback = callback;
            this.isDisposed = isDisposed;
        }

        public void execute(Boolean result) {
            this.callback.accept(result);
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen if draw map is enabled", t);
        }

        public boolean isDisposed() {
            return this.isDisposed.get();
        }
    }

    private static class DrawMapEnabledRequest
    extends UnaryRead<Resource, Boolean> {
        public DrawMapEnabledRequest(Resource diagram) {
            super((Object)diagram);
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            return DistrictNetworkUtil.drawMapEnabled((ReadGraph)graph, (Resource)((Resource)this.parameter));
        }
    }

    private static class MapBackgroundColorListener
    implements Listener<RGB.Integer> {
        private static final Logger LOGGER = LoggerFactory.getLogger(DrawMapEnabledListener.class);
        private Consumer<RGB.Integer> callback;
        private Supplier<Boolean> isDisposed;

        public MapBackgroundColorListener(Consumer<RGB.Integer> callback, Supplier<Boolean> isDisposed) {
            this.callback = callback;
            this.isDisposed = isDisposed;
        }

        public void execute(RGB.Integer result) {
            this.callback.accept(result);
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen map background color", t);
        }

        public boolean isDisposed() {
            return this.isDisposed.get();
        }
    }

    private static class MapBackgroundColorRequest
    extends UnaryRead<Resource, RGB.Integer> {
        public MapBackgroundColorRequest(Resource diagram) {
            super((Object)diagram);
        }

        public RGB.Integer perform(ReadGraph graph) throws DatabaseException {
            return DistrictNetworkUtil.backgroundColor((ReadGraph)graph, (Resource)((Resource)this.parameter));
        }
    }
}

