/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.binaryPredicates.OrderedSetElementsPredicate;
import org.simantics.modeling.adapters.ElementRemover;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNElementRemover
extends ElementRemover {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNElementRemover.class);

    public DNElementRemover(Resource element) {
        super(element);
    }

    public void removeConnection(WriteGraph graph) throws DatabaseException {
        throw new UnsupportedOperationException("Distrct network should not have STR.Connection resources! " + this.resource);
    }

    public void removeElement(WriteGraph graph) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(this.resource, DN.Vertex)) {
            graph.getObjects(this.resource, DN.HasEndVertex_Inverse).forEach(res -> {
                try {
                    DNElementRemover.doRemove(graph, res);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Could not remove endvertex inverse for {}", (Object)this.resource, (Object)e);
                }
            });
            graph.getObjects(this.resource, DN.HasStartVertex_Inverse).forEach(res -> {
                try {
                    DNElementRemover.doRemove(graph, res);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Could not remove startvertex inverse for {}", (Object)this.resource, (Object)e);
                }
            });
        }
        DNElementRemover.doRemove(graph, this.resource);
    }

    private static void doRemove(WriteGraph graph, Resource resource) throws DatabaseException {
        for (Resource diagram : OrderedSetElementsPredicate.INSTANCE.getSubjects((ReadGraph)graph, resource)) {
            OrderedSetUtils.remove((WriteGraph)graph, (Resource)diagram, (Resource)resource);
        }
        DNElementRemover.removePossibleMappedComponents(graph, resource);
        EntityRemover.remove((WriteGraph)graph, (Resource)resource);
    }

    private static void removePossibleMappedComponents(WriteGraph graph, Resource resource) throws DatabaseException {
        Boolean trackChangesEnabled = DistrictNetworkUtil.trackChangesEnabled((ReadGraph)graph, (Resource)graph.getPossibleObject(resource, Layer0.getInstance((ReadGraph)graph).PartOf));
        if (trackChangesEnabled.booleanValue()) {
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            Resource mappedComponent = graph.getPossibleObject(resource, DN.MappedComponent);
            if (mappedComponent != null) {
                RemoverUtil.remove((WriteGraph)graph, (Resource)mappedComponent);
            }
        }
    }
}

