/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.sg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.simantics.maps.WebService;
import org.simantics.maps.osm.OSMTileProvider;
import org.simantics.maps.pojo.TileJobQueue;
import org.simantics.maps.prefs.MapsClientPreferences;
import org.simantics.maps.tile.IFilter;
import org.simantics.maps.tile.ITileJobQueue;
import org.simantics.maps.tile.ITileListener;
import org.simantics.maps.tile.ITileProvider;
import org.simantics.maps.tile.TileCache;
import org.simantics.maps.tile.TileKey;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapNode
extends G2DNode
implements ITileListener {
    private static final long serialVersionUID = 2490944880914577411L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MapNode.class);
    private final double MAP_SCALE = 1.0;
    private final int MAX_TILE_LEVEL = 19;
    private final int TILE_PIXEL_SIZE = 256;
    private final int VIEWBOX_QUIET_TIME = 500;
    protected Boolean enabled = true;
    protected Color backgroundColor;
    private TileCache tileCache;
    private ScheduledFuture<?> pendingTileTask;
    private Map<Integer, TileLevel> neededTiles = new HashMap<Integer, TileLevel>();
    private TileTraverser tileTraverser = new TileTraverser();
    private ITileJobQueue job = null;
    private Map<TileKey, TileState> tileStates = new Hashtable<TileKey, TileState>();
    private ObjectHolder<VolatileImage> notLoadedImage = new ObjectHolder();
    private ObjectHolder<VolatileImage> loadingImage = new ObjectHolder();
    private ObjectHolder<VolatileImage> notAvailableImage = new ObjectHolder();
    private Font textFont = new Font("SansSerif", 1, 40);
    private AffineTransform oldTransform = new AffineTransform();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private Composite normalComposite = AlphaComposite.SrcOver.derive(1.0f);
    private Composite parentDataComposite = AlphaComposite.SrcOver.derive(0.75f);
    private Rectangle2D helperRect = new Rectangle2D.Double();
    ImageObserver observer = new ImageObserver(){

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            return true;
        }
    };

    public void init() {
        String url = MapsClientPreferences.useBuiltinServer() ? MapsClientPreferences.possibleBuiltinServerURL() : MapsClientPreferences.tileserverURL();
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        try {
            OSMTileProvider provider = new OSMTileProvider(new WebService(url), 256);
            try {
                Class<?> proxyClass = Class.forName("org.simantics.maps.eclipse.TileJobQueue");
                this.job = (ITileJobQueue)proxyClass.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (this.job == null) {
                this.job = new TileJobQueue();
            }
            ITileProvider cachedProvider = null;
            try {
                Class<?> proxyClass = Class.forName("org.simantics.maps.eclipse.DiskCachingTileProvider");
                cachedProvider = (ITileProvider)proxyClass.getConstructor(ITileProvider.class, Boolean.class).newInstance(provider, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (cachedProvider != null) {
                this.job.setTileProvider(cachedProvider);
            } else {
                this.job.setTileProvider(provider);
            }
            this.tileCache = new TileCache(this.job);
            this.tileCache.addTileListener(this);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize MapNode", (Throwable)e);
        }
    }

    @INode.SyncField(value={"enabled"})
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @INode.SyncField(value={"backgroundColor"})
    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void render(Graphics2D g2d) {
        AffineTransform ot = g2d.getTransform();
        g2d.transform(this.transform);
        AffineTransform tr = g2d.getTransform();
        double scaleX = Math.abs(tr.getScaleX());
        double scaleY = Math.abs(tr.getScaleY());
        if (scaleX <= 0.0 || scaleY <= 0.0) {
            return;
        }
        double offsetX = -tr.getTranslateX();
        double offsetY = -tr.getTranslateY();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D sp = this.localToControl(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0));
        Rectangle2D b = ((Rectangle)g2d.getRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_CONTROL_BOUNDS)).getBounds2D();
        Rectangle2D.Double viewbox = new Rectangle2D.Double(offsetX / scaleX, offsetY / scaleY, b.getWidth() / sp.getWidth(), b.getHeight() / sp.getHeight());
        if (this.enabled.booleanValue()) {
            double smallerViewboxDimension = ((RectangularShape)viewbox).getWidth() < ((RectangularShape)viewbox).getHeight() ? ((RectangularShape)viewbox).getWidth() * 1.0 : ((RectangularShape)viewbox).getHeight() * 1.0;
            int level = 0;
            double tileSize = 720.0;
            while (level < 19) {
                double ratio = smallerViewboxDimension / tileSize;
                if (ratio >= 0.85) break;
                tileSize *= 0.5;
                ++level;
            }
            double minx = Math.min(180.0, Math.max(viewbox.getMinX(), -180.0));
            double maxx = Math.min(180.0, Math.max(viewbox.getMaxX(), -180.0));
            double miny = Math.min(360.0, Math.max(viewbox.getMinY() + 180.0, 0.0));
            double maxy = Math.min(360.0, Math.max(viewbox.getMaxY() + 180.0, 0.0));
            g2d.setTransform(new AffineTransform());
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            int levels = 1 << level;
            int left = (int)Math.floor((minx + 180.0) / 360.0 * (double)(1 << level));
            int right = (int)Math.floor((maxx + 180.0) / 360.0 * (double)(1 << level));
            int top = (int)Math.floor(miny / 360.0 * (double)(1 << level));
            int bottom = (int)Math.floor(maxy / 360.0 * (double)(1 << level));
            double tsx = 360.0 / (double)levels;
            int tx = left;
            while (tx <= right) {
                if (tx >= 0 && tx < levels) {
                    int ty = top;
                    while (ty <= bottom) {
                        if (ty >= 0 && ty < levels) {
                            TileKey tile = new TileKey(level, tx, ty);
                            double y = (double)ty - (double)levels / 2.0;
                            this.paintTile(this.tileCache, g2d, tr, tile, (double)tx * tsx - 180.0, y * tsx, tsx);
                        }
                        ++ty;
                    }
                }
                ++tx;
            }
            this.transformChanged(tr, level);
        } else if (this.backgroundColor != null) {
            g2d.setTransform(new AffineTransform());
            Rectangle2D controlBounds = (Rectangle2D)g2d.getRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_CONTROL_BOUNDS);
            Color color = g2d.getColor();
            g2d.setColor(this.backgroundColor);
            g2d.fill(controlBounds);
            g2d.setColor(color);
        }
        g2d.setTransform(ot);
    }

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    private void paintTile(TileCache cache, Graphics2D g, AffineTransform userToScreenTransform, TileKey tile, double tx, double ty, double tileSize) {
        GraphicsConfiguration gc = g.getDeviceConfiguration();
        Image img = null;
        boolean usingParentData = false;
        this.helperRect.setFrame(0.0, 0.0, 256.0, 256.0);
        TileState state = this.tileStates.get(tile);
        if (state == null) {
            state = TileState.NOT_LOADED;
        }
        switch (state) {
            case NOT_LOADED: 
            case LOADED: {
                Pair<TileKey, Image> p;
                img = cache.peek(tile);
                if (img == null) {
                    this.needTile(tile);
                    p = this.findFirstAvailableParentTile(cache, tile, this.tileTraverser);
                    if (p != null) {
                        img = (Image)p.second;
                        this.helperRect.setFrame(0.0, 0.0, img.getWidth(this.observer), img.getHeight(this.observer));
                        this.traverseRectangle(this.tileTraverser, this.helperRect);
                        usingParentData = true;
                        break;
                    }
                    img = this.getNotLoadedImage(gc);
                    break;
                }
                this.helperRect.setFrame(0.0, 0.0, img.getWidth(this.observer), img.getHeight(this.observer));
                break;
            }
            case LOADING: {
                Pair<TileKey, Image> p = this.findFirstAvailableParentTile(cache, tile, this.tileTraverser);
                if (p != null) {
                    img = (Image)p.second;
                    this.helperRect.setFrame(0.0, 0.0, img.getWidth(this.observer), img.getHeight(this.observer));
                    this.traverseRectangle(this.tileTraverser, this.helperRect);
                    usingParentData = true;
                    break;
                }
                img = this.getLoadingImage(gc);
                break;
            }
            case NOT_AVAILABLE: {
                img = this.getMissingImage(gc);
                break;
            }
            default: {
                throw new Error("Invalid tile state: " + (Object)((Object)state));
            }
        }
        Point2D.Double helperPoint1 = new Point2D.Double(tx, ty);
        Point2D.Double helperPoint2 = new Point2D.Double(tx + tileSize, ty + tileSize);
        userToScreenTransform.transform(helperPoint1, helperPoint1);
        userToScreenTransform.transform(helperPoint2, helperPoint2);
        int dx1 = (int)Math.round(((Point2D)helperPoint1).getX());
        int dy1 = (int)Math.round(((Point2D)helperPoint1).getY());
        int dx2 = (int)Math.round(((Point2D)helperPoint2).getX());
        int dy2 = (int)Math.round(((Point2D)helperPoint2).getY());
        int sx1 = (int)Math.round(this.helperRect.getMinX());
        int sy1 = (int)Math.round(this.helperRect.getMinY());
        int sx2 = (int)Math.round(this.helperRect.getMaxX());
        int sy2 = (int)Math.round(this.helperRect.getMaxY());
        if (usingParentData) {
            g.setComposite(this.parentDataComposite);
        } else {
            g.setComposite(this.normalComposite);
        }
        g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this.observer);
    }

    private void transformChanged(AffineTransform newTransform, final int level) {
        double s2;
        double ds;
        AffineTransform ato = this.oldTransform;
        AffineTransform atn = newTransform;
        double s1 = -1.0;
        if (ato != null) {
            s1 = ato.getScaleX();
        }
        if (Math.abs(ds = (s2 = atn.getScaleX()) - s1) > 1.0E-6) {
            if (this.pendingTileTask != null) {
                this.pendingTileTask.cancel(false);
                this.pendingTileTask = null;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    MapNode.this.loadNeededTiles(level);
                }
            };
            this.pendingTileTask = this.scheduler.schedule(r, 500L, TimeUnit.MILLISECONDS);
            this.oldTransform = (AffineTransform)newTransform.clone();
        } else {
            this.loadNeededTiles(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNeededTiles(final int level) {
        TileCache cache = this.tileCache;
        cache.filterJobQueue(new IFilter<TileKey>(){

            @Override
            public boolean select(TileKey tile) {
                boolean result = tile.getLevel() == level;
                return result;
            }
        });
        TileLevel l = null;
        Map<Integer, TileLevel> map = this.neededTiles;
        synchronized (map) {
            l = this.neededTiles.get(level);
            this.neededTiles.clear();
        }
        if (l != null && !l.isEmpty()) {
            for (TileKey k : l) {
                this.tileStates.put(k, TileState.LOADING);
                this.tileCache.get(k);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void needTile(TileKey t) {
        Map<Integer, TileLevel> map = this.neededTiles;
        synchronized (map) {
            int level = t.getLevel();
            TileLevel l = this.neededTiles.get(level);
            if (l == null) {
                l = new TileLevel();
                this.neededTiles.put(level, l);
            }
            l.add(t);
        }
    }

    private Pair<TileKey, Image> findFirstAvailableParentTile(TileCache cache, TileKey tile, TileTraverser traverser) {
        traverser.clear();
        traverser.add(tile);
        TileKey parent = this.getParentTile(tile);
        while (parent != null) {
            Image img = cache.peek(parent);
            if (img != null) {
                return new Pair<TileKey, Image>(parent, img);
            }
            traverser.add(parent);
            parent = this.getParentTile(parent);
        }
        return null;
    }

    private TileKey getParentTile(TileKey k) {
        if (k.getLevel() == 0) {
            return null;
        }
        return new TileKey(k.getLevel() - 1, k.getX() / 2, k.getY() / 2);
    }

    private void traverseRectangle(TileTraverser traverser, Rectangle2D rect) {
        int i = traverser.size() - 1;
        while (i >= 0) {
            this.traverseToQuadrant(rect, traverser.getQuadrant(i));
            --i;
        }
    }

    private Rectangle2D traverseToQuadrant(Rectangle2D r, int quadrant) {
        boolean left = quadrant == 1 || quadrant == 2;
        boolean top = quadrant == 1 || quadrant == 0;
        r.setFrame(left ? r.getMinX() : r.getCenterX(), top ? r.getMinY() : r.getCenterY(), r.getWidth() / 2.0, r.getHeight() / 2.0);
        return r;
    }

    private synchronized VolatileImage getNotLoadedImage(GraphicsConfiguration gc) {
        return this.validateImageWithCenteredText(gc, this.notLoadedImage, 256, "NOT LOADED", Color.LIGHT_GRAY, Color.BLACK);
    }

    private synchronized VolatileImage getLoadingImage(GraphicsConfiguration gc) {
        return this.validateImageWithCenteredText(gc, this.loadingImage, 256, "LOADING", Color.BLUE, Color.BLACK);
    }

    private synchronized VolatileImage getMissingImage(GraphicsConfiguration gc) {
        return this.validateImageWithCenteredText(gc, this.notAvailableImage, 256, "NOT AVAILABLE", Color.RED, Color.DARK_GRAY);
    }

    private void drawImageWithCenteredText(VolatileImage image, String str, Font font, Color color, Color bgColor) {
        Graphics2D target = image.createGraphics();
        Rectangle2D bb = target.getFontMetrics(font).getStringBounds(str, target);
        target.setBackground(new Color(255, 255, 255, 0));
        int w = image.getWidth();
        int h = image.getHeight();
        target.setColor(Color.BLACK);
        target.fillRect(0, 0, w, h);
        target.setColor(bgColor);
        target.fillRect(2, 2, w - 3, h - 3);
        target.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        target.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        target.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        target.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        target.setColor(color);
        target.setFont(font);
        target.drawString(str, (float)(((double)w - bb.getWidth()) / 2.0), (float)(((double)h + bb.getHeight()) / 2.0));
        target.dispose();
    }

    private VolatileImage validateImageWithCenteredText(GraphicsConfiguration gc, ObjectHolder<VolatileImage> container, int size, String text, Color textColor, Color bgColor) {
        VolatileImage image = container.get();
        if (image != null) {
            int validateResult = image.validate(gc);
            if (validateResult == 2) {
                image = null;
            } else {
                if (validateResult == 0) {
                    return image;
                }
                if (validateResult == 1) {
                    this.drawImageWithCenteredText(image, text, this.textFont, textColor, bgColor);
                }
            }
        }
        if (image == null) {
            image = gc.createCompatibleVolatileImage(size, size);
            container.set(image);
            this.drawImageWithCenteredText(image, text, this.textFont, textColor, bgColor);
        }
        return image;
    }

    @Override
    public void tileCanceled(TileKey key) {
        this.tileStates.put(key, TileState.NOT_LOADED);
    }

    @Override
    public void tileFailed(TileKey key, Throwable e) {
        this.tileStates.put(key, TileState.NOT_AVAILABLE);
        this.repaint();
    }

    @Override
    public void tileUpdated(TileKey key, Image image) {
        this.tileStates.put(key, TileState.LOADED);
        this.repaint();
    }

    public class ObjectHolder<T> {
        private T o = null;

        public T get() {
            return this.o;
        }

        public void set(T o) {
            this.o = o;
        }
    }

    public final class Pair<T1, T2> {
        public final T1 first;
        public final T2 second;

        public Pair(T1 first, T2 second) {
            this.first = first;
            this.second = second;
        }
    }

    class TileLevel
    extends HashSet<TileKey> {
        private static final long serialVersionUID = 5743763238677223952L;

        TileLevel() {
        }
    }

    static enum TileState {
        NOT_LOADED,
        LOADING,
        LOADED,
        NOT_AVAILABLE;

    }

    static class TileTraverser {
        List<TileKey> tile = new ArrayList<TileKey>(4);
        List<Integer> quadrant = new ArrayList<Integer>(4);

        TileTraverser() {
        }

        static int getTileQuadrant(TileKey k) {
            int x = k.getX();
            int y = k.getY();
            if ((x & 1) == 0) {
                return (y & 1) == 0 ? 1 : 2;
            }
            return (y & 1) == 0 ? 0 : 3;
        }

        void clear() {
            this.tile.clear();
            this.quadrant.clear();
        }

        void add(TileKey tile) {
            this.tile.add(tile);
            this.quadrant.add(TileTraverser.getTileQuadrant(tile));
        }

        int size() {
            return this.tile.size();
        }

        TileKey getTile(int i) {
            return this.tile.get(i);
        }

        int getQuadrant(int i) {
            return this.quadrant.get(i);
        }
    }
}

